/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.TypeDescription;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSymbolTreeDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class MissingReturnedValueDescriptionDiagnostic
extends AbstractSymbolTreeDiagnostic {
    @Override
    public void visitMethod(MethodSymbol methodSymbol) {
        Optional<MethodDescription> description = methodSymbol.getDescription();
        boolean hasDescription = description.isPresent();
        if (!hasDescription) {
            return;
        }
        List returnedValueDescription = description.map(MethodDescription::getReturnedValue).orElse(Collections.emptyList());
        if (!methodSymbol.isFunction() && returnedValueDescription.isEmpty()) {
            return;
        }
        if (!methodSymbol.isFunction()) {
            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getResourceString("isProcedure"));
            return;
        }
        if (returnedValueDescription.isEmpty()) {
            if (!description.get().getLink().isEmpty()) {
                return;
            }
            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getMessage());
            return;
        }
        String typesWithoutDescription = returnedValueDescription.stream().filter(typeDescription -> typeDescription.getDescription().isEmpty() && typeDescription.getParameters().isEmpty()).map(TypeDescription::getName).collect(Collectors.joining(", "));
        if (!typesWithoutDescription.isEmpty()) {
            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getResourceString("typesWithoutDescription", typesWithoutDescription));
        }
    }
}

