/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.CRITICAL, minutesToFix=3, tags={DiagnosticTag.STANDARD, DiagnosticTag.PERFORMANCE, DiagnosticTag.BADPRACTICE}, activatedByDefault=false)
public class MissingTempStorageDeletionDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern GET_FROM_TEMP_STORAGE_PATTERN = CaseInsensitivePattern.compile((String)"\u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0438\u0437\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430|getfromtempstorage");
    private static final Pattern DELETE_FROM_TEMP_STORAGE_PATTERN = CaseInsensitivePattern.compile((String)"\u0443\u0434\u0430\u043b\u0438\u0442\u044c\u0438\u0437\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430|deletefromtempstorage");
    @Nullable
    private BSLParser.SubContext currentSub;
    private Collection<? extends ParseTree> subStatements = Collections.emptyList();
    @Nullable
    private BSLParser.FileCodeBlockContext fileCodeBlock;
    private Collection<? extends ParseTree> fileCodeBlockStatements = Collections.emptyList();
    @Nullable
    private BSLParser.FileCodeBlockBeforeSubContext fileCodeBlockBeforeSub;
    private Collection<? extends ParseTree> fileCodeBlockBeforeSubStatements = Collections.emptyList();

    public MissingTempStorageDeletionDiagnostic() {
        super(GET_FROM_TEMP_STORAGE_PATTERN);
    }

    @Override
    protected boolean checkMethodCall(BSLParser.MethodCallContext ctx) {
        return false;
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        ParseTree result = (ParseTree)super.visitFile(ctx);
        this.currentSub = null;
        this.fileCodeBlock = null;
        this.fileCodeBlockBeforeSub = null;
        this.subStatements.clear();
        this.fileCodeBlockStatements.clear();
        this.fileCodeBlockBeforeSubStatements.clear();
        return result;
    }

    public ParseTree visitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.fileCodeBlockBeforeSub = ctx;
        this.fileCodeBlock = null;
        this.currentSub = null;
        return (ParseTree)super.visitFileCodeBlockBeforeSub(ctx);
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.fileCodeBlock = ctx;
        this.currentSub = null;
        this.fileCodeBlockBeforeSub = null;
        return (ParseTree)super.visitFileCodeBlock(ctx);
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.currentSub = ctx;
        this.fileCodeBlock = null;
        this.fileCodeBlockBeforeSub = null;
        this.subStatements.clear();
        return (ParseTree)super.visitSub(ctx);
    }

    @Override
    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        this.check(ctx);
        return false;
    }

    private void check(BSLParser.GlobalMethodCallContext ctx) {
        boolean isInsideFileCodeBlockBeforeSub;
        boolean isInsideSub = this.currentSub != null;
        boolean isInsideFileCodeBlock = this.fileCodeBlock != null;
        boolean bl = isInsideFileCodeBlockBeforeSub = this.fileCodeBlockBeforeSub != null;
        if (!super.checkGlobalMethodCall(ctx) || !isInsideSub && !isInsideFileCodeBlock && !isInsideFileCodeBlockBeforeSub) {
            return;
        }
        Collection<? extends ParseTree> statements = this.getStatements(isInsideSub, isInsideFileCodeBlock, isInsideFileCodeBlockBeforeSub);
        BSLParser.DoCallContext sourceCallContext = ctx.doCall();
        int line = ctx.getStop().getLine();
        if (statements.stream().filter(BSLParser.StatementContext.class::isInstance).map(BSLParser.StatementContext.class::cast).filter(statement -> MissingTempStorageDeletionDiagnostic.greaterOrEqual(statement, line)).noneMatch(statement -> MissingTempStorageDeletionDiagnostic.haveDeleteFromTempStorageCall(statement, sourceCallContext))) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
    }

    private Collection<? extends ParseTree> getStatements(boolean isInsideSub, boolean isInsideFileCodeBlock, boolean isInsideFileCodeBlockBeforeSub) {
        if (isInsideSub) {
            if (this.subStatements.isEmpty()) {
                this.subStatements = this.calcSubStatements();
            }
            return this.subStatements;
        }
        if (isInsideFileCodeBlock) {
            if (this.fileCodeBlockStatements.isEmpty()) {
                this.fileCodeBlockStatements = MissingTempStorageDeletionDiagnostic.findAllStatementsInside(this.fileCodeBlock.codeBlock());
            }
            return this.fileCodeBlockStatements;
        }
        if (isInsideFileCodeBlockBeforeSub) {
            if (this.fileCodeBlockBeforeSubStatements.isEmpty()) {
                this.fileCodeBlockBeforeSubStatements = MissingTempStorageDeletionDiagnostic.findAllStatementsInside(this.fileCodeBlockBeforeSub.codeBlock());
            }
            return this.fileCodeBlockBeforeSubStatements;
        }
        throw new IllegalStateException();
    }

    private Collection<? extends ParseTree> calcSubStatements() {
        BSLParser.SubCodeBlockContext subCodeBlock = this.getSubCodeBlockContext();
        return MissingTempStorageDeletionDiagnostic.findAllStatementsInside(subCodeBlock.codeBlock());
    }

    private BSLParser.SubCodeBlockContext getSubCodeBlockContext() {
        BSLParser.ProcedureContext method = this.currentSub.procedure();
        if (method == null) {
            return this.currentSub.function().subCodeBlock();
        }
        return method.subCodeBlock();
    }

    private static Collection<? extends ParseTree> findAllStatementsInside(BSLParser.CodeBlockContext codeBlockContext) {
        return Trees.findAllRuleNodes((ParseTree)codeBlockContext, 77);
    }

    private static boolean greaterOrEqual(BSLParser.StatementContext statement, int line) {
        return statement.getStart().getLine() > line;
    }

    private static boolean haveDeleteFromTempStorageCall(BSLParser.StatementContext statement, BSLParser.DoCallContext sourceCallCtx) {
        return Trees.findAllRuleNodes((ParseTree)statement, 90).stream().map(parseTree -> (BSLParser.GlobalMethodCallContext)parseTree).filter(globalMethodCall -> DELETE_FROM_TEMP_STORAGE_PATTERN.matcher(globalMethodCall.methodName().getText()).matches()).anyMatch(globalMethodCall -> DiagnosticHelper.equalNodes((Tree)sourceCallCtx, (Tree)globalMethodCall.doCall()));
    }
}

