/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, scope=DiagnosticScope.ALL, minutesToFix=10, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.BRAINOVERLOAD})
public class NestedConstructorsInStructureDeclarationDiagnostic
extends AbstractVisitorDiagnostic {
    private String relatedMessage;

    @PostConstruct
    public void init() {
        this.relatedMessage = this.info.getResourceString("nestedConstructorRelatedMessage");
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        BSLParser.TypeNameContext typeName = ctx.typeName();
        if (typeName == null || !DiagnosticHelper.isStructureType((ParseTree)typeName) && !DiagnosticHelper.isFixedStructureType((ParseTree)typeName)) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        BSLParser.DoCallContext structureDoCallContext = ctx.doCall();
        if (structureDoCallContext == null) {
            return ctx;
        }
        if (structureDoCallContext.callParamList().callParam().size() <= 1) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)ctx), this.relatedMessage));
        structureDoCallContext.callParamList().callParam().stream().filter(tree -> tree.start.getType() == 69).map(tree -> Trees.findAllRuleNodes((ParseTree)tree, 87)).filter(tree -> !tree.isEmpty()).map(tree -> (ParseTree)tree.toArray()[0]).map(tree -> (BSLParser.NewExpressionContext)tree).filter(NestedConstructorsInStructureDeclarationDiagnostic::hasParams).map(newContext -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)newContext), this.relatedMessage)).collect(Collectors.toCollection(() -> relatedInformation));
        if (relatedInformation.size() > 1) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, relatedInformation);
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private static boolean hasParams(BSLParser.NewExpressionContext newContext) {
        BSLParser.DoCallContext doCallContext = newContext.doCall();
        return doCallContext != null && doCallContext.callParamList().callParam().stream().anyMatch(param -> param.getChildCount() > 0);
    }
}

