/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectComplex;
import com.github._1c_syntax.mdclasses.mdo.attributes.AbstractMDOAttribute;
import com.github._1c_syntax.mdclasses.mdo.attributes.TabularSection;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import java.util.List;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.SQL, DiagnosticTag.DESIGN}, modules={ModuleType.ManagerModule, ModuleType.ObjectModule, ModuleType.SessionModule}, scope=DiagnosticScope.BSL)
public class SameMetadataObjectAndChildNamesDiagnostic
extends AbstractMetadataDiagnostic {
    private final LanguageServerConfiguration serverConfiguration;

    SameMetadataObjectAndChildNamesDiagnostic(LanguageServerConfiguration serverConfiguration) {
        super(List.of(MDOType.ACCOUNTING_REGISTER, MDOType.ACCUMULATION_REGISTER, MDOType.BUSINESS_PROCESS, MDOType.CALCULATION_REGISTER, MDOType.CATALOG, MDOType.CHART_OF_ACCOUNTS, MDOType.CHART_OF_CALCULATION_TYPES, MDOType.CHART_OF_CHARACTERISTIC_TYPES, MDOType.DOCUMENT, MDOType.EXCHANGE_PLAN, MDOType.INFORMATION_REGISTER, MDOType.TASK));
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    protected void checkMetadata(AbstractMDObjectBase mdo) {
        if (!(mdo instanceof AbstractMDObjectComplex) || ((AbstractMDObjectComplex)mdo).getAttributes().isEmpty()) {
            return;
        }
        String mdoName = mdo.getName().intern();
        ((AbstractMDObjectComplex)mdo).getAttributes().stream().filter(attribute -> mdoName.equalsIgnoreCase(attribute.getName())).forEach(attribute -> this.addAttributeDiagnostic((AbstractMDOAttribute)attribute, mdoName));
        ((AbstractMDObjectComplex)mdo).getAttributes().stream().filter(TabularSection.class::isInstance).map(TabularSection.class::cast).forEach(table -> {
            String tableName = table.getName().intern();
            table.getAttributes().stream().filter(attribute -> tableName.equalsIgnoreCase(attribute.getName())).forEach(attribute -> this.addAttributeDiagnostic((AbstractMDOAttribute)attribute, tableName));
        });
    }

    private void addAttributeDiagnostic(AbstractMDOAttribute attribute, String mdoName) {
        String mdoRef = this.serverConfiguration.getLanguage() == Language.RU ? attribute.getMdoReference().getMdoRefRu() : attribute.getMdoReference().getMdoRef();
        this.addDiagnostic(this.info.getMessage(mdoRef, mdoName));
    }
}

