/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.common.CompatibilityMode;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=5, tags={DiagnosticTag.UNPREDICTABLE, DiagnosticTag.STANDARD})
public class TimeoutsInExternalResourcesDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern PATTERN_TIMEOUT = CaseInsensitivePattern.compile((String)"^\\.(\u0422\u0430\u0439\u043c\u0430\u0443\u0442|Timeout)");
    private static final Pattern PATTERN_NEW_EXPRESSION = CaseInsensitivePattern.compile((String)"^(FTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|FTPConnection|HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|HTTPConnection|WS\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f|WSDefinitions|WS\u041f\u0440\u043e\u043a\u0441\u0438|WSProxy)");
    private static final Pattern PATTERN_NEW_EXPRESSION_WITH_MAIL = CaseInsensitivePattern.compile((String)"^(FTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|FTPConnection|HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|HTTPConnection|WS\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f|WSDefinitions|WS\u041f\u0440\u043e\u043a\u0441\u0438|WSProxy|\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439\u041f\u0440\u043e\u0444\u0438\u043b\u044c|InternetMailProfile)");
    private static final boolean ANALYZING_MAIL = true;
    private int defaultNumberTimeout = 5;
    private int defaultNumberTimeoutFtp = 6;
    private int defaultNumberTimeoutWsd = 4;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean analyzeInternetMailProfileZeroTimeout = true;

    private Pattern getPatternNewExpression() {
        if (this.analyzeInternetMailProfileZeroTimeout) {
            return PATTERN_NEW_EXPRESSION_WITH_MAIL;
        }
        return PATTERN_NEW_EXPRESSION;
    }

    private static String getVariableName(@CheckForNull BSLParser.StatementContext statement) {
        BSLParser.LValueContext lValueContext;
        String variableName = "";
        if (statement != null && statement.assignment() != null && (lValueContext = statement.assignment().lValue()) != null) {
            variableName = lValueContext.getStart().getText();
        }
        return variableName;
    }

    private boolean isSpecificTypeName(BSLParser.NewExpressionContext newExpression) {
        BSLParser.TypeNameContext typeNameContext = newExpression.typeName();
        if (typeNameContext == null) {
            return false;
        }
        return this.getPatternNewExpression().matcher(typeNameContext.getText()).find();
    }

    private static boolean isWSDefinitions(BSLParser.NewExpressionContext newExpression) {
        return newExpression.typeName() != null && DiagnosticHelper.isWSDefinitionsType((ParseTree)newExpression.typeName());
    }

    private static boolean isFTPConnection(BSLParser.NewExpressionContext newExpression) {
        return newExpression.typeName() != null && DiagnosticHelper.isFTPConnectionType((ParseTree)newExpression.typeName());
    }

    private static boolean isInternetMailProfile(BSLParser.NewExpressionContext newExpression) {
        return newExpression.typeName() != null && DiagnosticHelper.isInternetMailProfileType((ParseTree)newExpression.typeName());
    }

    private static boolean isNumberOrVariable(BSLParser.MemberContext member) {
        if (member.constValue() != null) {
            return member.constValue().numeric() != null;
        }
        return member.complexIdentifier() != null;
    }

    private boolean checkTimeoutIntoParamList(BSLParser.NewExpressionContext newExpression, AtomicBoolean isContact) {
        BSLParser.MemberContext memberContext;
        BSLParser.DoCallContext doCallContext = newExpression.doCall();
        if (doCallContext == null) {
            return true;
        }
        int numberTimeout = TimeoutsInExternalResourcesDiagnostic.isWSDefinitions(newExpression) ? this.defaultNumberTimeoutWsd : (TimeoutsInExternalResourcesDiagnostic.isFTPConnection(newExpression) ? this.defaultNumberTimeoutFtp : (TimeoutsInExternalResourcesDiagnostic.isInternetMailProfile(newExpression) ? 5 : this.defaultNumberTimeout));
        List listParams = doCallContext.callParamList().callParam();
        if (listParams == null || listParams.size() <= numberTimeout) {
            return true;
        }
        boolean needContinue = true;
        BSLParser.ExpressionContext expression = ((BSLParser.CallParamContext)listParams.get(numberTimeout)).expression();
        if (expression != null && !expression.member().isEmpty() && TimeoutsInExternalResourcesDiagnostic.isNumberOrVariable(memberContext = expression.member(0))) {
            needContinue = false;
            isContact.set(false);
        }
        return needContinue;
    }

    private static void checkNextStatement(Collection<BSLParser.StatementContext> listNextStatements, String variableName, AtomicBoolean isContact) {
        listNextStatements.forEach(localStatement -> {
            String thisVariableName = TimeoutsInExternalResourcesDiagnostic.getVariableName(localStatement);
            if (thisVariableName.equalsIgnoreCase(variableName) && TimeoutsInExternalResourcesDiagnostic.isTimeoutModifier(localStatement) && TimeoutsInExternalResourcesDiagnostic.isNumberOrVariable(localStatement.assignment().expression().member(0))) {
                isContact.set(false);
            }
        });
    }

    private static boolean isTimeoutModifier(BSLParser.StatementContext localStatement) {
        ArrayList<ParseTree> allRuleNodes;
        BSLParser.AcceptorContext acceptor;
        BSLParser.AssignmentContext assignmentContext = localStatement.assignment();
        if (assignmentContext == null) {
            return false;
        }
        BSLParser.LValueContext lValue = assignmentContext.lValue();
        if (!lValue.isEmpty() && (acceptor = lValue.acceptor()) != null && !(allRuleNodes = new ArrayList<ParseTree>(Trees.findAllRuleNodes((ParseTree)acceptor, 98))).isEmpty()) {
            BSLParser.AccessPropertyContext accessProperty = (BSLParser.AccessPropertyContext)allRuleNodes.get(0);
            return PATTERN_TIMEOUT.matcher(accessProperty.getText()).find();
        }
        return false;
    }

    public ParseTree visitCodeBlock(BSLParser.CodeBlockContext ctx) {
        Trees.findAllRuleNodes((ParseTree)ctx, 87).stream().map(BSLParser.NewExpressionContext.class::cast).forEach(newExpression -> {
            AtomicBoolean isContact = new AtomicBoolean(true);
            if (this.isSpecificTypeName((BSLParser.NewExpressionContext)newExpression)) {
                if (this.checkTimeoutIntoParamList((BSLParser.NewExpressionContext)newExpression, isContact)) {
                    BSLParser.StatementContext statementContext = (BSLParser.StatementContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)newExpression, 77);
                    String variableName = TimeoutsInExternalResourcesDiagnostic.getVariableName(statementContext);
                    int filterLine = newExpression.getStart().getLine();
                    Collection listNextStatements = Trees.findAllRuleNodes((ParseTree)ctx, 77).stream().map(node -> (BSLParser.StatementContext)node).filter(node -> node.getStart().getLine() > filterLine).collect(Collectors.toList());
                    TimeoutsInExternalResourcesDiagnostic.checkNextStatement(listNextStatements, variableName, isContact);
                }
                if (isContact.get()) {
                    this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)newExpression, this.info.getMessage());
                }
            }
        });
        return ctx;
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        CompatibilityMode diagnosticCompatibility = this.documentContext.getServerContext().getConfiguration().getCompatibilityMode();
        if (diagnosticCompatibility != null && CompatibilityMode.compareTo((CompatibilityMode)diagnosticCompatibility, (CompatibilityMode)DiagnosticCompatibilityMode.UNDEFINED.getCompatibilityMode()) != 0) {
            if (CompatibilityMode.compareTo((CompatibilityMode)diagnosticCompatibility, (CompatibilityMode)DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_7.getCompatibilityMode()) == 1) {
                this.defaultNumberTimeout = 4;
                this.defaultNumberTimeoutWsd = 3;
            }
            if (CompatibilityMode.compareTo((CompatibilityMode)diagnosticCompatibility, (CompatibilityMode)DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_9.getCompatibilityMode()) == 1) {
                this.defaultNumberTimeoutFtp = 5;
            }
        }
        return (ParseTree)super.visitFile(ctx);
    }
}

