/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class UsageWriteLogEventDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern WRITELOGEVENT = CaseInsensitivePattern.compile((String)"\u0437\u0430\u043f\u0438\u0441\u044c\u0436\u0443\u0440\u043d\u0430\u043b\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438|writelogevent");
    private static final Pattern PATTERN_DETAIL_ERROR_DESCRIPTION = CaseInsensitivePattern.compile((String)"\u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0435\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043e\u0448\u0438\u0431\u043a\u0438|detailerrordescription");
    private static final Pattern PATTERN_ERROR_INFO = CaseInsensitivePattern.compile((String)"\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\u043e\u0431\u043e\u0448\u0438\u0431\u043a\u0435|errorinfo");
    private static final Pattern PATTERN_BRIEF_ERROR_DESCRIPTION = CaseInsensitivePattern.compile((String)"\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u043e\u0448\u0438\u0431\u043a\u0438|errordescription");
    private static final Pattern PATTERN_EVENT_LOG_LEVEL = CaseInsensitivePattern.compile((String)"\u0443\u0440\u043e\u0432\u0435\u043d\u044c\u0436\u0443\u0440\u043d\u0430\u043b\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438|eventloglevel");
    private static final Pattern PATTERN_ERROR = CaseInsensitivePattern.compile((String)"\u043e\u0448\u0438\u0431\u043a\u0430|error");
    private static final int WRITE_LOG_EVENT_METHOD_PARAMS_COUNT = 5;

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        if (!UsageWriteLogEventDiagnostic.checkMethodName(ctx)) {
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        List callParams = ctx.doCall().callParamList().callParam();
        if (callParams.size() < 5) {
            this.fireIssue(ctx, "wrongNumberMessage");
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        BSLParser.CallParamContext secondParamCtx = (BSLParser.CallParamContext)callParams.get(1);
        if (secondParamCtx.getChildCount() == 0) {
            this.fireIssue(ctx, "noSecondParameter");
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        BSLParser.CallParamContext commentCtx = (BSLParser.CallParamContext)callParams.get(4);
        if (commentCtx.getChildCount() == 0) {
            this.fireIssue(ctx, "noComment");
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        if (!UsageWriteLogEventDiagnostic.hasErrorLogLevel(secondParamCtx) && UsageWriteLogEventDiagnostic.isInsideExceptBlock((BSLParserRuleContext)ctx)) {
            this.fireIssue(ctx, "noErrorLogLevelInsideExceptBlock");
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        if (!UsageWriteLogEventDiagnostic.isCommentCorrect(commentCtx)) {
            this.fireIssue(ctx, "noDetailErrorDescription");
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    private static boolean checkMethodName(BSLParser.GlobalMethodCallContext ctx) {
        return WRITELOGEVENT.matcher(ctx.methodName().getText()).matches();
    }

    private void fireIssue(BSLParser.GlobalMethodCallContext ctx, String messageKey) {
        String diagnosticMessage = this.info.getResourceString(messageKey);
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, diagnosticMessage);
    }

    private static boolean hasErrorLogLevel(BSLParser.CallParamContext callParamContext) {
        Optional<BSLParser.ComplexIdentifierContext> complexIdentifier = Optional.of(callParamContext).map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).filter(memberContexts -> memberContexts.size() == 1).map(memberContexts -> (BSLParser.MemberContext)memberContexts.get(0)).map(BSLParser.MemberContext::complexIdentifier).filter(identifier -> identifier.IDENTIFIER() != null);
        if (complexIdentifier.isEmpty()) {
            return true;
        }
        boolean result = complexIdentifier.filter(identifier -> PATTERN_EVENT_LOG_LEVEL.matcher(identifier.IDENTIFIER().getText()).matches()).filter(identifier -> identifier.modifier().size() == 1).map(identifier -> identifier.modifier(0)).map(BSLParser.ModifierContext::accessProperty).filter(accessProperty -> PATTERN_ERROR.matcher(accessProperty.IDENTIFIER().getText()).matches()).isPresent();
        if (result) {
            return true;
        }
        return complexIdentifier.filter(identifier -> identifier.getChildCount() == 1).isPresent();
    }

    private static boolean isCommentCorrect(BSLParser.CallParamContext commentsCtx) {
        BSLParser.CodeBlockContext codeBlockContext = (BSLParser.CodeBlockContext)Trees.getRootParent((BSLParserRuleContext)commentsCtx, 69);
        if (codeBlockContext == null) {
            return false;
        }
        if (UsageWriteLogEventDiagnostic.hasRaiseStatement(codeBlockContext)) {
            return true;
        }
        return UsageWriteLogEventDiagnostic.isValidExpression(codeBlockContext, commentsCtx.expression(), true);
    }

    private static boolean hasRaiseStatement(BSLParser.CodeBlockContext codeBlockContext) {
        return codeBlockContext.statement().stream().map(BSLParser.StatementContext::compoundStatement).filter(Objects::nonNull).map(BSLParser.CompoundStatementContext::raiseStatement).anyMatch(Objects::nonNull);
    }

    private static boolean isValidExpression(BSLParser.CodeBlockContext codeBlock, @Nullable BSLParser.ExpressionContext expression, boolean checkPrevAssignment) {
        if (expression == null) {
            return true;
        }
        Collection<ParseTree> assignmentGlobalCalls = Trees.findAllRuleNodes((ParseTree)expression, 90);
        if (!assignmentGlobalCalls.isEmpty()) {
            if (UsageWriteLogEventDiagnostic.isErrorDescriptionCallCorrect(assignmentGlobalCalls)) {
                return true;
            }
            if (UsageWriteLogEventDiagnostic.hasBriefErrorDescription(assignmentGlobalCalls)) {
                return false;
            }
        }
        return UsageWriteLogEventDiagnostic.isValidExpression(expression, codeBlock, checkPrevAssignment);
    }

    private static boolean isErrorDescriptionCallCorrect(Collection<ParseTree> globalCalls) {
        return globalCalls.stream().filter(ctx -> ctx instanceof BSLParser.GlobalMethodCallContext).map(BSLParser.GlobalMethodCallContext.class::cast).filter(ctx -> UsageWriteLogEventDiagnostic.isAppropriateName(ctx, PATTERN_DETAIL_ERROR_DESCRIPTION)).anyMatch(UsageWriteLogEventDiagnostic::hasFirstDescendantGlobalCall);
    }

    private static boolean isAppropriateName(BSLParser.GlobalMethodCallContext ctx, Pattern patternDetailErrorDescription) {
        return patternDetailErrorDescription.matcher(ctx.methodName().getText()).matches();
    }

    private static boolean hasFirstDescendantGlobalCall(BSLParser.GlobalMethodCallContext globalCallCtx) {
        return Trees.findAllRuleNodes((ParseTree)globalCallCtx, 90).stream().map(BSLParser.GlobalMethodCallContext.class::cast).anyMatch(ctx -> UsageWriteLogEventDiagnostic.isAppropriateName(ctx, PATTERN_ERROR_INFO));
    }

    private static boolean hasBriefErrorDescription(Collection<ParseTree> globalCalls) {
        return globalCalls.stream().filter(ctx -> ctx instanceof BSLParser.GlobalMethodCallContext).anyMatch(ctx -> UsageWriteLogEventDiagnostic.isAppropriateName((BSLParser.GlobalMethodCallContext)ctx, PATTERN_BRIEF_ERROR_DESCRIPTION));
    }

    private static boolean isValidExpression(BSLParser.ExpressionContext ctx, BSLParser.CodeBlockContext codeBlock, boolean checkPrevAssignment) {
        return ctx.member().stream().allMatch(memberContext -> UsageWriteLogEventDiagnostic.isValidExpression(memberContext, codeBlock, checkPrevAssignment));
    }

    private static boolean isValidExpression(BSLParser.MemberContext ctx, BSLParser.CodeBlockContext codeBlock, boolean checkPrevAssignment) {
        BSLParser.ComplexIdentifierContext complexIdentifier;
        if (!UsageWriteLogEventDiagnostic.isInsideExceptBlock((BSLParserRuleContext)codeBlock) && ctx.constValue() != null) {
            return true;
        }
        if (checkPrevAssignment && (complexIdentifier = ctx.complexIdentifier()) != null) {
            return UsageWriteLogEventDiagnostic.isValidVarAssignment(complexIdentifier, codeBlock);
        }
        return false;
    }

    private static boolean isValidVarAssignment(BSLParser.ComplexIdentifierContext var, BSLParser.CodeBlockContext codeBlock) {
        String varName = var.getText();
        return UsageWriteLogEventDiagnostic.getAssignment(varName, codeBlock).map(BSLParser.AssignmentContext::expression).map(expression -> UsageWriteLogEventDiagnostic.isValidExpression(codeBlock, expression, false)).orElse(true);
    }

    private static Optional<BSLParser.AssignmentContext> getAssignment(String varName, BSLParser.CodeBlockContext codeBlock) {
        return Optional.of(codeBlock).map(BSLParser.CodeBlockContext::statement).filter(statementContexts -> !statementContexts.isEmpty()).map(statementContexts -> codeBlock.statement(0)).map(BSLParser.StatementContext::assignment).filter(assignmentContext -> assignmentContext.lValue().getText().equalsIgnoreCase(varName));
    }

    private static boolean isInsideExceptBlock(BSLParserRuleContext ctx) {
        return Trees.getRootParent(ctx, 61) != null;
    }
}

