/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.VULNERABILITY, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.BSL, minutesToFix=15, tags={DiagnosticTag.STANDARD})
public class UsingHardcodeSecretInformationDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String FIND_WORD_DEFAULT = "\u041f\u0430\u0440\u043e\u043b\u044c|Password";
    private static final Pattern PATTERN_NEW_EXPRESSION = CaseInsensitivePattern.compile((String)"\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430|Structure|\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435|Map|FTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|FTPConnection|HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|HTTPConnection");
    private static final Pattern PATTERN_NEW_EXPRESSION_CONNECTION = CaseInsensitivePattern.compile((String)"FTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|FTPConnection|HTTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435|HTTPConnection");
    private static final Pattern PATTERN_METHOD_INSERT = CaseInsensitivePattern.compile((String)"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c|Insert");
    private static final Pattern PATTERN_CHECK_PASSWORD = Pattern.compile("^[\\*]+$", 64);
    @DiagnosticParameter(type=String.class, defaultValue="\u041f\u0430\u0440\u043e\u043b\u044c|Password")
    private Pattern searchWords = UsingHardcodeSecretInformationDiagnostic.getPatternSearch("\u041f\u0430\u0440\u043e\u043b\u044c|Password");

    @Override
    public void configure(Map<String, Object> configuration) {
        String searchWordsProperty = (String)configuration.getOrDefault("searchWords", FIND_WORD_DEFAULT);
        this.searchWords = UsingHardcodeSecretInformationDiagnostic.getPatternSearch(searchWordsProperty);
    }

    private static Pattern getPatternSearch(String value) {
        return CaseInsensitivePattern.compile((String)("^(" + value + ")$"));
    }

    public ParseTree visitAssignment(BSLParser.AssignmentContext ctx) {
        List list;
        Matcher matcher = this.searchWords.matcher(ctx.getStart().getText());
        if (matcher.find() && (list = ctx.expression().getTokens()).size() == 1 && UsingHardcodeSecretInformationDiagnostic.isNotEmptyStringByToken((Token)list.get(0))) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
        return (ParseTree)super.visitAssignment(ctx);
    }

    public ParseTree visitAccessIndex(BSLParser.AccessIndexContext ctx) {
        if (UsingHardcodeSecretInformationDiagnostic.parentIsModifierContext((ParserRuleContext)ctx)) {
            return (ParseTree)super.visitAccessIndex(ctx);
        }
        List list = ctx.expression().getTokens();
        if (list.size() == 1) {
            this.processCheckAssignmentKey((BSLParserRuleContext)ctx, ((Token)list.get(0)).getText());
        }
        return (ParseTree)super.visitAccessIndex(ctx);
    }

    public ParseTree visitAccessProperty(BSLParser.AccessPropertyContext ctx) {
        if (UsingHardcodeSecretInformationDiagnostic.parentIsModifierContext((ParserRuleContext)ctx)) {
            return (ParseTree)super.visitAccessProperty(ctx);
        }
        this.processCheckAssignmentKey((BSLParserRuleContext)ctx, ctx.getStop().getText());
        return (ParseTree)super.visitAccessProperty(ctx);
    }

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        List list;
        Matcher matcher;
        Matcher matcherMethod = PATTERN_METHOD_INSERT.matcher(ctx.methodName().getText());
        if (matcherMethod.find() && (matcher = this.searchWords.matcher(UsingHardcodeSecretInformationDiagnostic.getClearString(((BSLParser.CallParamContext)(list = ctx.doCall().callParamList().callParam()).get(0)).getText()))).find() && list.size() > 1 && UsingHardcodeSecretInformationDiagnostic.isNotEmptyStringByToken(((BSLParser.CallParamContext)list.get(1)).getStart())) {
            this.addDiagnosticByAssignment((BSLParserRuleContext)ctx, 77);
        }
        return (ParseTree)super.visitMethodCall(ctx);
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        List list;
        BSLParser.DoCallContext doCallContext;
        BSLParser.TypeNameContext typeNameContext = ctx.typeName();
        if (typeNameContext == null) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        Matcher matcherTypeName = PATTERN_NEW_EXPRESSION.matcher(typeNameContext.getText());
        if (matcherTypeName.find() && (doCallContext = ctx.doCall()) != null && !(list = doCallContext.callParamList().callParam()).isEmpty()) {
            this.processCheckNewExpression(ctx, list, typeNameContext.getText());
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private void processCheckNewExpression(BSLParser.NewExpressionContext ctx, List<? extends BSLParser.CallParamContext> list, String typeName) {
        Matcher matcherTypeNameConnection = PATTERN_NEW_EXPRESSION_CONNECTION.matcher(typeName);
        if (matcherTypeNameConnection.find()) {
            if (list.size() >= 4 && UsingHardcodeSecretInformationDiagnostic.isNotEmptyStringByToken(list.get(3).getStart())) {
                this.addDiagnosticByAssignment((BSLParserRuleContext)ctx, 78);
            }
        } else {
            this.processParameterList(ctx, list);
        }
    }

    private void processCheckAssignmentKey(BSLParserRuleContext ctx, String accessText) {
        BSLParserRuleContext assignment;
        Matcher matcher = this.searchWords.matcher(UsingHardcodeSecretInformationDiagnostic.getClearString(accessText));
        if (matcher.find() && (assignment = Trees.getAncestorByRuleIndex(ctx.getRuleContext(), 78)) != null && ((BSLParser.AssignmentContext)assignment).expression().getChildCount() == 1 && UsingHardcodeSecretInformationDiagnostic.isNotEmptyStringByToken(assignment.getStop())) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)((BSLParser.AssignmentContext)assignment), this.info.getMessage());
        }
    }

    private void processParameterList(BSLParser.NewExpressionContext ctx, List<? extends BSLParser.CallParamContext> list) {
        String[] arr = list.get(0).getText().split(",");
        for (int index = 0; index < arr.length; ++index) {
            Matcher matcher = this.searchWords.matcher(UsingHardcodeSecretInformationDiagnostic.getClearString(arr[index]));
            if (!matcher.find() || list.size() <= index + 1 || !UsingHardcodeSecretInformationDiagnostic.isNotEmptyStringByToken(list.get(index + 1).getStart())) continue;
            this.addDiagnosticByAssignment((BSLParserRuleContext)ctx, 78);
            break;
        }
    }

    private void addDiagnosticByAssignment(BSLParserRuleContext ctx, int type) {
        BSLParserRuleContext assignment = Trees.getAncestorByRuleIndex(ctx.getRuleContext(), type);
        if (assignment != null) {
            this.diagnosticStorage.addDiagnostic(assignment, this.info.getMessage());
        }
    }

    private static boolean isNotEmptyStringByToken(Token token) {
        boolean foundStars;
        boolean result;
        boolean bl = result = token.getType() == 37 && token.getText().length() > 2;
        if (result && (foundStars = PATTERN_CHECK_PASSWORD.matcher(token.getText().substring(1, token.getText().length() - 1)).find())) {
            result = false;
        }
        return result;
    }

    private static String getClearString(String inputString) {
        return inputString.replace("\"", "").replace(" ", "");
    }

    private static boolean parentIsModifierContext(ParserRuleContext ctx) {
        return ctx.getParent() instanceof BSLParser.ModifierContext;
    }
}

