/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.children.Form;
import com.github._1c_syntax.mdclasses.mdo.children.form.FormItem;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=5, scope=DiagnosticScope.BSL, modules={ModuleType.FormModule, ModuleType.ManagedApplicationModule}, tags={DiagnosticTag.UNPREDICTABLE})
public class WrongDataPathForFormElementsDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    @Override
    protected void check() {
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (!Ranges.isEmpty(range)) {
            this.checkCurrentModule(range);
        }
    }

    private static boolean wrongDataPath(FormItem formItem) {
        return formItem.getDataPath().getSegment().startsWith("~");
    }

    private static boolean haveFormModules(Form form) {
        return !form.getModules().isEmpty();
    }

    private void checkCurrentModule(Range range) {
        this.diagnosticRange = range;
        if (this.documentContext.getModuleType() == ModuleType.FormModule) {
            this.checkMdoObjectStream(WrongDataPathForFormElementsDiagnostic::haveFormModules, this.documentContext.getMdObject().stream());
        } else {
            this.checkAllFormsWithoutModules();
        }
    }

    private void checkAllFormsWithoutModules() {
        this.checkMdoObjectStream(form -> !WrongDataPathForFormElementsDiagnostic.haveFormModules(form), this.documentContext.getServerContext().getConfiguration().getChildrenByMdoRef().values().stream());
    }

    private void checkMdoObjectStream(Predicate<Form> formFilter, Stream<AbstractMDObjectBase> stream) {
        stream.filter(Form.class::isInstance).map(Form.class::cast).filter(formFilter).forEach(this::checkForm);
    }

    private void checkForm(Form form) {
        form.getData().getPlainChildren().stream().filter(WrongDataPathForFormElementsDiagnostic::wrongDataPath).forEach(formItem -> this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(formItem.getName(), this.getMdoRef(form))));
    }

    private String getMdoRef(Form form) {
        if (this.documentContext.getServerContext().getConfiguration().getScriptVariant() == ScriptVariant.ENGLISH) {
            return form.getMdoReference().getMdoRef();
        }
        return form.getMdoReference().getMdoRefRu();
    }
}

