/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.mdo.MDWebService;
import com.github._1c_syntax.mdclasses.mdo.children.WEBServiceOperation;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS, DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL, modules={ModuleType.WEBServiceModule})
public class WrongWebServiceHandlerDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    @Override
    protected void check() {
        Ranges.getFirstSignificantTokenRange(this.documentContext.getTokens()).ifPresent(this::processModuleWithRange);
    }

    private void processModuleWithRange(Range range) {
        this.diagnosticRange = range;
        this.documentContext.getMdObject().filter(MDWebService.class::isInstance).map(MDWebService.class::cast).ifPresent(this::checkService);
        this.diagnosticRange = null;
    }

    private void checkService(MDWebService mdWebService) {
        mdWebService.getOperations().forEach(webServiceOperation -> this.checkOperation(mdWebService.getName(), (WEBServiceOperation)webServiceOperation));
    }

    private void checkOperation(String serviceName, WEBServiceOperation webServiceOperation) {
        String operationName = webServiceOperation.getName();
        String handler = webServiceOperation.getHandler();
        if (handler.isEmpty()) {
            this.addMissingHandlerDiagnostic(serviceName, operationName);
            return;
        }
        this.checkMethod(serviceName, operationName, handler);
    }

    private void checkMethod(String serviceName, String operationName, String handlerName) {
        if (this.documentContext.getSymbolTree().getMethodSymbol(handlerName).isEmpty()) {
            this.addDefaultDiagnostic(serviceName, operationName, handlerName);
        }
    }

    private void addDefaultDiagnostic(String serviceName, String operationName, String handlerName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(handlerName, operationName, serviceName));
    }

    private void addMissingHandlerDiagnostic(String serviceName, String operationName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getResourceString("missingHandler", operationName, serviceName));
    }
}

