/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.folding;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.folding.FoldingRangeSupplier;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.FoldingRange;
import org.springframework.stereotype.Component;

@Component
public class CodeBlockFoldingRangeSupplier
implements FoldingRangeSupplier {
    @Override
    public List<FoldingRange> getFoldingRanges(DocumentContext documentContext) {
        CodeBlockVisitor codeBlockVisitor = new CodeBlockVisitor();
        codeBlockVisitor.visitFile(documentContext.getAst());
        return codeBlockVisitor.getRegionRanges();
    }

    private static class CodeBlockVisitor
    extends BSLParserBaseVisitor<ParseTree> {
        private final List<FoldingRange> regionRanges = new ArrayList<FoldingRange>();

        private CodeBlockVisitor() {
        }

        public ParseTree visitProcedure(BSLParser.ProcedureContext ctx) {
            this.addRegionRange(ctx.procDeclaration().PROCEDURE_KEYWORD(), ctx.ENDPROCEDURE_KEYWORD());
            return (ParseTree)super.visitProcedure(ctx);
        }

        public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
            this.addRegionRange(ctx.funcDeclaration().FUNCTION_KEYWORD(), ctx.ENDFUNCTION_KEYWORD());
            return (ParseTree)super.visitFunction(ctx);
        }

        public ParseTree visitIfStatement(BSLParser.IfStatementContext ctx) {
            this.addRegionRange(ctx.ifBranch().IF_KEYWORD(), ctx.ENDIF_KEYWORD());
            return (ParseTree)super.visitIfStatement(ctx);
        }

        public ParseTree visitWhileStatement(BSLParser.WhileStatementContext ctx) {
            this.addRegionRange(ctx.WHILE_KEYWORD(), ctx.ENDDO_KEYWORD());
            return (ParseTree)super.visitWhileStatement(ctx);
        }

        public ParseTree visitForStatement(BSLParser.ForStatementContext ctx) {
            this.addRegionRange(ctx.FOR_KEYWORD(), ctx.ENDDO_KEYWORD());
            return (ParseTree)super.visitForStatement(ctx);
        }

        public ParseTree visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
            this.addRegionRange(ctx.FOR_KEYWORD(), ctx.ENDDO_KEYWORD());
            return (ParseTree)super.visitForEachStatement(ctx);
        }

        public ParseTree visitTryStatement(BSLParser.TryStatementContext ctx) {
            this.addRegionRange(ctx.TRY_KEYWORD(), ctx.ENDTRY_KEYWORD());
            return (ParseTree)super.visitTryStatement(ctx);
        }

        private void addRegionRange(@CheckForNull TerminalNode start, @CheckForNull TerminalNode stop) {
            if (start == null || stop == null) {
                return;
            }
            int startLine = start.getSymbol().getLine();
            int stopLine = stop.getSymbol().getLine();
            if (stopLine > startLine) {
                FoldingRange foldingRange = new FoldingRange(startLine - 1, stopLine - 1);
                foldingRange.setKind("region");
                this.regionRanges.add(foldingRange);
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<FoldingRange> getRegionRanges() {
            return this.regionRanges;
        }
    }
}

