/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceResolver;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.Position;
import org.springframework.stereotype.Component;

@Component
public class CallHierarchyProvider {
    private final ReferenceResolver referenceResolver;
    private final ReferenceIndex referenceIndex;

    public List<CallHierarchyItem> prepareCallHierarchy(DocumentContext documentContext, CallHierarchyPrepareParams params) {
        Position position = params.getPosition();
        return this.referenceResolver.findReference(documentContext.getUri(), position).flatMap(Reference::getSourceDefinedSymbol).map(CallHierarchyProvider::getCallHierarchyItem).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public List<CallHierarchyIncomingCall> incomingCalls(DocumentContext documentContext, CallHierarchyIncomingCallsParams params) {
        URI uri = documentContext.getUri();
        CallHierarchyItem item = params.getItem();
        Position position = item.getSelectionRange().getStart();
        return this.referenceResolver.findReference(uri, position).flatMap(Reference::getSourceDefinedSymbol).stream().map(this.referenceIndex::getReferencesTo).flatMap(Collection::stream).collect(Collectors.groupingBy(Reference::getFrom, Collectors.mapping(Reference::getSelectionRange, Collectors.toCollection(ArrayList::new)))).entrySet().stream().map(entry -> new CallHierarchyIncomingCall(CallHierarchyProvider.getCallHierarchyItem((SourceDefinedSymbol)entry.getKey()), (List)entry.getValue())).collect(Collectors.toList());
    }

    public List<CallHierarchyOutgoingCall> outgoingCalls(DocumentContext documentContext, CallHierarchyOutgoingCallsParams params) {
        URI uri = documentContext.getUri();
        Position position = params.getItem().getSelectionRange().getStart();
        return this.referenceResolver.findReference(uri, position).flatMap(Reference::getSourceDefinedSymbol).stream().map(this.referenceIndex::getReferencesFrom).flatMap(Collection::stream).filter(Reference::isSourceDefinedSymbolReference).collect(Collectors.groupingBy(reference -> reference.getSourceDefinedSymbol().orElseThrow(), Collectors.mapping(Reference::getSelectionRange, Collectors.toCollection(ArrayList::new)))).entrySet().stream().map(entry -> new CallHierarchyOutgoingCall(CallHierarchyProvider.getCallHierarchyItem((SourceDefinedSymbol)entry.getKey()), (List)entry.getValue())).collect(Collectors.toList());
    }

    private static CallHierarchyItem getCallHierarchyItem(SourceDefinedSymbol sourceDefinedSymbol) {
        String detail = MdoRefBuilder.getMdoRef(sourceDefinedSymbol.getOwner());
        CallHierarchyItem item = new CallHierarchyItem();
        item.setName(sourceDefinedSymbol.getName());
        item.setDetail(detail);
        item.setKind(sourceDefinedSymbol.getSymbolKind());
        item.setTags(sourceDefinedSymbol.getTags());
        item.setUri(sourceDefinedSymbol.getOwner().getUri().toString());
        item.setRange(sourceDefinedSymbol.getRange());
        item.setSelectionRange(sourceDefinedSymbol.getSelectionRange());
        return item;
    }

    @ConstructorProperties(value={"referenceResolver", "referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallHierarchyProvider(ReferenceResolver referenceResolver, ReferenceIndex referenceIndex) {
        this.referenceResolver = referenceResolver;
        this.referenceIndex = referenceIndex;
    }
}

