/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public final class DocumentSymbolProvider {
    public static final String LABEL = "BSL Language Server";

    public List<Either<SymbolInformation, DocumentSymbol>> getDocumentSymbols(DocumentContext documentContext) {
        return documentContext.getSymbolTree().getChildren().stream().map(DocumentSymbolProvider::toDocumentSymbol).map(Either::forRight).collect(Collectors.toList());
    }

    private static DocumentSymbol toDocumentSymbol(SourceDefinedSymbol symbol) {
        DocumentSymbol documentSymbol = new DocumentSymbol(symbol.getName(), symbol.getSymbolKind(), symbol.getRange(), symbol.getSelectionRange());
        List children = symbol.getChildren().stream().map(DocumentSymbolProvider::toDocumentSymbol).collect(Collectors.toList());
        documentSymbol.setTags(symbol.getTags());
        documentSymbol.setChildren(children);
        return documentSymbol;
    }
}

