/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.springframework.stereotype.Component;

@Component
public final class FormatProvider {
    private static final Set<Integer> incrementIndentTokens = new HashSet<Integer>(Arrays.asList(6, 41, 42, 49, 50, 51, 55, 53, 59, 60));
    private static final Set<Integer> decrementIndentTokens = new HashSet<Integer>(Arrays.asList(7, 50, 51, 43, 44, 47, 48, 60, 61));
    private static final Set<Integer> primitiveTokenTypes = new HashSet<Integer>(Arrays.asList(33, 35, 34, 30, 31, 32, 36, 37));

    public List<TextEdit> getFormatting(DocumentFormattingParams params, DocumentContext documentContext) {
        List<Token> tokens = documentContext.getTokens();
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        Token firstToken = tokens.get(0);
        Token lastToken = tokens.get(tokens.size() - 1);
        return FormatProvider.getTextEdits(tokens, Ranges.create(firstToken, lastToken), firstToken.getCharPositionInLine(), params.getOptions());
    }

    public List<TextEdit> getRangeFormatting(DocumentRangeFormattingParams params, DocumentContext documentContext) {
        Position start = params.getRange().getStart();
        Position end = params.getRange().getEnd();
        int startLine = start.getLine() + 1;
        int startCharacter = start.getCharacter();
        int endLine = end.getLine() + 1;
        int endCharacter = end.getCharacter();
        List<Token> tokens = documentContext.getTokens().stream().filter(token -> {
            int tokenLine = token.getLine();
            int tokenCharacter = token.getCharPositionInLine();
            return FormatProvider.inLineRange(startLine, endLine, tokenLine) || tokenLine == endLine && FormatProvider.betweenStartAndStopCharacters(startCharacter, endCharacter, tokenCharacter);
        }).collect(Collectors.toList());
        return FormatProvider.getTextEdits(tokens, params.getRange(), startCharacter, params.getOptions());
    }

    private static boolean betweenStartAndStopCharacters(int startCharacter, int endCharacter, int tokenCharacter) {
        return tokenCharacter >= startCharacter && tokenCharacter < endCharacter;
    }

    private static boolean inLineRange(int startLine, int endLine, int tokenLine) {
        return tokenLine >= startLine && tokenLine < endLine;
    }

    private static List<TextEdit> getTextEdits(List<Token> tokens, Range range, int startCharacter, FormattingOptions options) {
        String newText = FormatProvider.getNewText(tokens, range, startCharacter, options);
        if (newText.isEmpty()) {
            return Collections.emptyList();
        }
        TextEdit edit = new TextEdit(range, newText);
        return List.of(edit);
    }

    public static String getNewText(List<Token> tokens, Range range, int startCharacter, FormattingOptions options) {
        if (tokens.isEmpty()) {
            return "";
        }
        List<Token> filteredTokens = FormatProvider.filteredTokens(tokens);
        if (filteredTokens.isEmpty()) {
            return "";
        }
        int tabSize = options.getTabSize();
        boolean insertSpaces = options.isInsertSpaces();
        StringBuilder newTextBuilder = new StringBuilder();
        Token firstToken = filteredTokens.get(0);
        String indentation = insertSpaces ? StringUtils.repeat((char)' ', (int)tabSize) : "\t";
        int currentIndentLevel = (firstToken.getCharPositionInLine() - startCharacter) / indentation.length();
        int additionalIndentLevel = -1;
        boolean inMethodDefinition = false;
        boolean insideOperator = false;
        boolean parameterDeclarationMode = false;
        int lastLine = firstToken.getLine();
        int previousTokenType = -1;
        boolean previousIsUnary = false;
        for (Token token : filteredTokens) {
            String currentIndentation;
            boolean needNewLine;
            int tokenType = token.getType();
            boolean bl = needNewLine = token.getLine() != lastLine;
            if (tokenType == 42 || tokenType == 41) {
                inMethodDefinition = true;
            }
            if (inMethodDefinition && tokenType == 7) {
                inMethodDefinition = false;
            }
            switch (tokenType) {
                case 49: 
                case 50: 
                case 53: 
                case 55: {
                    insideOperator = true;
                }
            }
            if (insideOperator) {
                switch (tokenType) {
                    case 52: 
                    case 54: {
                        insideOperator = false;
                    }
                }
            }
            if (previousTokenType == 120 && tokenType == 6) {
                parameterDeclarationMode = true;
            }
            if (needNewLine) {
                currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append(StringUtils.repeat((String)("\n" + currentIndentation), (int)(token.getLine() - lastLine - 1)));
            }
            if (FormatProvider.needDecrementIndent(tokenType) && tokenType != 7 && --currentIndentLevel == additionalIndentLevel) {
                --currentIndentLevel;
                additionalIndentLevel = -1;
            }
            if (token.equals(firstToken)) {
                newTextBuilder.append(StringUtils.repeat((String)indentation, (int)currentIndentLevel));
            } else if (needNewLine) {
                currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append("\n");
                newTextBuilder.append(currentIndentation);
            } else if (FormatProvider.needAddSpace(tokenType, previousTokenType, previousIsUnary)) {
                newTextBuilder.append(' ');
            }
            String addedText = token.getText();
            if (tokenType == 1) {
                addedText = addedText.trim();
            }
            newTextBuilder.append(addedText);
            if (FormatProvider.needIncrementIndent(tokenType)) {
                ++currentIndentLevel;
            }
            if (tokenType == 11 && additionalIndentLevel < 0 && !inMethodDefinition && !insideOperator) {
                additionalIndentLevel = ++currentIndentLevel;
            }
            if (additionalIndentLevel > 0 && (tokenType == 9 || parameterDeclarationMode && FormatProvider.isPrimitive(tokenType))) {
                --currentIndentLevel;
                additionalIndentLevel = -1;
            }
            if (parameterDeclarationMode && tokenType == 7) {
                parameterDeclarationMode = false;
            }
            lastLine = token.getLine();
            previousIsUnary = FormatProvider.isUnary(tokenType, previousTokenType);
            previousTokenType = tokenType;
        }
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getText().endsWith("\n") || lastToken.getText().endsWith("\r")) {
            newTextBuilder.append("\n");
            if (range.getEnd().getCharacter() != 0) {
                String currentIndentation = StringUtils.repeat((String)indentation, (int)currentIndentLevel);
                newTextBuilder.append(currentIndentation);
            }
        }
        return newTextBuilder.toString();
    }

    private static List<Token> filteredTokens(List<Token> tokens) {
        return tokens.stream().filter(token -> token.getChannel() == 0 || token.getType() == 1).collect(Collectors.toList());
    }

    private static boolean needAddSpace(int type, int previousTokenType, boolean previousIsUnary) {
        if (previousIsUnary) {
            return false;
        }
        switch (previousTokenType) {
            case 3: 
            case 4: 
            case 23: 
            case 27: 
            case 29: {
                return false;
            }
            case 6: {
                return type == 10;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                return true;
            }
        }
        if (type == 6) {
            switch (previousTokenType) {
                case 22: 
                case 64: 
                case 69: 
                case 72: 
                case 76: 
                case 120: {
                    return false;
                }
            }
            return true;
        }
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    private static boolean isUnary(int type, int previousTokenType) {
        if (type != 13) {
            return false;
        }
        switch (previousTokenType) {
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    private static boolean needIncrementIndent(int tokenType) {
        return incrementIndentTokens.contains(tokenType);
    }

    private static boolean needDecrementIndent(int tokenType) {
        return decrementIndentTokens.contains(tokenType);
    }

    private static boolean isPrimitive(int tokenType) {
        return primitiveTokenTypes.contains(tokenType);
    }
}

