/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.util.Positions;
import org.springframework.stereotype.Component;

@Component
public class SelectionRangeProvider {
    private static final Set<Integer> SKIPPED_NODES = Set.of(99, 96, 90, 55, 56, 100, 49, 45, 50, 51, 52, 53, 42, 43, 44, 54, 59, 64, 65, 78);

    public List<SelectionRange> getSelectionRange(DocumentContext documentContext, SelectionRangeParams params) {
        List positions = params.getPositions();
        BSLParser.FileContext ast = documentContext.getAst();
        return positions.stream().map(position -> SelectionRangeProvider.findNodeContainsPosition((BSLParserRuleContext)ast, position)).map(terminalNode -> terminalNode.orElse(null)).map(SelectionRangeProvider::toSelectionRange).collect(Collectors.toList());
    }

    @CheckForNull
    private static SelectionRange toSelectionRange(@Nullable ParseTree node) {
        if (node == null) {
            return null;
        }
        Range range = Ranges.create(node);
        SelectionRange selectionRange = new SelectionRange();
        selectionRange.setRange(range);
        SelectionRangeProvider.nextParentWithDifferentRange(node).map(SelectionRangeProvider::toSelectionRange).ifPresent(arg_0 -> ((SelectionRange)selectionRange).setParent(arg_0));
        return selectionRange;
    }

    private static Optional<ParseTree> nextParentWithDifferentRange(ParseTree ctx) {
        BSLParserRuleContext parent = SelectionRangeProvider.getParentContext(ctx);
        if (parent == null) {
            return Optional.empty();
        }
        boolean needToSkipNode = SKIPPED_NODES.contains(parent.getRuleIndex());
        needToSkipNode = needToSkipNode || SelectionRangeProvider.ifBranchMatchesIfStatement(parent);
        Range currentRange = Ranges.create(ctx);
        Range parentRange = Ranges.create((ParserRuleContext)parent);
        if (needToSkipNode || parentRange.equals((Object)currentRange)) {
            return SelectionRangeProvider.nextParentWithDifferentRange((ParseTree)parent);
        }
        return Optional.of(parent);
    }

    private static BSLParserRuleContext getParentContext(ParseTree ctx) {
        if (ctx instanceof BSLParser.StatementContext) {
            return SelectionRangeProvider.getStatementParent((BSLParser.StatementContext)ctx);
        }
        return SelectionRangeProvider.getDefaultParent(ctx);
    }

    @CheckForNull
    private static BSLParserRuleContext getDefaultParent(ParseTree ctx) {
        return (BSLParserRuleContext)ctx.getParent();
    }

    private static BSLParserRuleContext getStatementParent(BSLParser.StatementContext statement) {
        BSLParserRuleContext child;
        int i;
        BSLParserRuleContext parent = SelectionRangeProvider.getDefaultParent((ParseTree)statement);
        int statementLine = statement.getStart().getLine();
        BSLParser.CodeBlockContext codeBlock = (BSLParser.CodeBlockContext)statement.getParent();
        List<Tree> children = Trees.getChildren((Tree)codeBlock);
        int currentPosition = children.indexOf(statement);
        ArrayList<Object> nearbyStatements = new ArrayList<Object>();
        int localLine = statementLine;
        for (i = currentPosition + 1; i < children.size() && (child = (BSLParserRuleContext)children.get(i)).getStart().getLine() == localLine + 1; ++i) {
            nearbyStatements.add(child);
            ++localLine;
        }
        localLine = statementLine;
        for (i = currentPosition - 1; i >= 0 && (child = (BSLParserRuleContext)children.get(i)).getStart().getLine() == localLine - 1; --i) {
            nearbyStatements.add(child);
            --localLine;
        }
        if (!nearbyStatements.isEmpty() && nearbyStatements.size() + 1 != children.size()) {
            BSLParserRuleContext statementsBlock = new BSLParserRuleContext();
            statementsBlock.setParent((RuleContext)parent);
            nearbyStatements.add(statement);
            nearbyStatements.sort(Comparator.comparing(ruleContext -> ruleContext.getStart().getLine()));
            nearbyStatements.forEach(ruleContext -> ruleContext.setParent((RuleContext)statementsBlock));
            nearbyStatements.forEach(arg_0 -> ((BSLParserRuleContext)statementsBlock).addChild(arg_0));
            nearbyStatements.forEach(ruleContext -> ruleContext.setParent((RuleContext)codeBlock));
            statementsBlock.start = ((ParserRuleContext)nearbyStatements.get(0)).getStart();
            statementsBlock.stop = ((ParserRuleContext)nearbyStatements.get(nearbyStatements.size() - 1)).getStop();
            parent = statementsBlock;
        }
        return parent;
    }

    private static boolean ifBranchMatchesIfStatement(BSLParserRuleContext ctx) {
        if (!(ctx instanceof BSLParser.IfBranchContext)) {
            return false;
        }
        BSLParser.IfBranchContext ifBranch = (BSLParser.IfBranchContext)ctx;
        BSLParser.IfStatementContext ifStatement = (BSLParser.IfStatementContext)ifBranch.getParent();
        return ifStatement.elseBranch() == null && ifStatement.elsifBranch().isEmpty();
    }

    private static Optional<TerminalNode> findNodeContainsPosition(BSLParserRuleContext tree, Position position) {
        if (tree.getTokens().isEmpty()) {
            return Optional.empty();
        }
        Token start = tree.getStart();
        Token stop = tree.getStop();
        if (!SelectionRangeProvider.positionIsAfterOrOnToken(position, start) || !SelectionRangeProvider.positionIsBeforeOrOnToken(position, stop)) {
            return Optional.empty();
        }
        List<Tree> children = Trees.getChildren((Tree)tree);
        for (Tree child : children) {
            if (child instanceof TerminalNode) {
                TerminalNode terminalNode = (TerminalNode)child;
                Token token = terminalNode.getSymbol();
                if (!SelectionRangeProvider.tokenContainsPosition(token, position)) continue;
                return Optional.of(terminalNode);
            }
            Optional<TerminalNode> node = SelectionRangeProvider.findNodeContainsPosition((BSLParserRuleContext)child, position);
            if (!node.isPresent()) continue;
            return node;
        }
        return Optional.empty();
    }

    private static boolean tokenContainsPosition(Token token, Position position) {
        Range tokenRange = Ranges.create(token);
        return Ranges.containsPosition(tokenRange, position);
    }

    private static boolean positionIsBeforeOrOnToken(Position position, Token token) {
        Range tokenRange = Ranges.create(token);
        Position end = tokenRange.getEnd();
        return Positions.isBefore((Position)position, (Position)end) || end.equals((Object)position);
    }

    private static boolean positionIsAfterOrOnToken(Position position, Token token) {
        Range tokenRange = Ranges.create(token);
        Position start = tokenRange.getStart();
        return Positions.isBefore((Position)start, (Position)position) || start.equals((Object)position);
    }
}

