/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Exportable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.references.model.Location;
import com.github._1c_syntax.bsl.languageserver.references.model.LocationRepository;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.references.model.Symbol;
import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrence;
import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrenceRepository;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class ReferenceIndex {
    private final ServerContext serverContext;
    private final LocationRepository locationRepository;
    private final SymbolOccurrenceRepository symbolOccurrenceRepository;

    public List<Reference> getReferencesTo(SourceDefinedSymbol symbol) {
        String mdoRef = MdoRefBuilder.getMdoRef(symbol.getOwner());
        ModuleType moduleType = symbol.getOwner().getModuleType();
        String symbolName = symbol.getName().toLowerCase(Locale.ENGLISH);
        Symbol symbolDto = Symbol.builder().mdoRef(mdoRef).moduleType(moduleType).scopeName("").symbolKind(symbol.getSymbolKind()).symbolName(symbolName).build();
        return this.symbolOccurrenceRepository.getAllBySymbol(symbolDto).stream().map(this::buildReference).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public Optional<Reference> getReference(URI uri, Position position) {
        return this.locationRepository.getSymbolOccurrencesByLocationUri(uri).filter(symbolOccurrence -> Ranges.containsPosition(symbolOccurrence.getLocation().getRange(), position)).findAny().flatMap(this::buildReference);
    }

    public List<Reference> getReferencesFrom(URI uri) {
        return this.locationRepository.getSymbolOccurrencesByLocationUri(uri).map(this::buildReference).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public List<Reference> getReferencesFrom(SourceDefinedSymbol symbol) {
        return this.getReferencesFrom(symbol.getOwner().getUri()).stream().filter(reference -> reference.getFrom().equals(symbol)).collect(Collectors.toList());
    }

    public void clearReferences(URI uri) {
        Stream<SymbolOccurrence> symbolOccurrences = this.locationRepository.getSymbolOccurrencesByLocationUri(uri);
        this.symbolOccurrenceRepository.deleteAll(symbolOccurrences.collect(Collectors.toSet()));
        this.locationRepository.delete(uri);
    }

    public void addMethodCall(URI uri, String mdoRef, ModuleType moduleType, String symbolName, Range range) {
        String symbolNameCanonical = symbolName.toLowerCase(Locale.ENGLISH);
        Symbol symbol = Symbol.builder().mdoRef(mdoRef).moduleType(moduleType).scopeName("").symbolKind(SymbolKind.Method).symbolName(symbolNameCanonical).build();
        Location location = new Location(uri, range);
        SymbolOccurrence symbolOccurrence = SymbolOccurrence.builder().occurrenceType(OccurrenceType.REFERENCE).symbol(symbol).location(location).build();
        this.symbolOccurrenceRepository.save(symbolOccurrence);
        this.locationRepository.updateLocation(symbolOccurrence);
    }

    private Optional<Reference> buildReference(SymbolOccurrence symbolOccurrence) {
        URI uri = symbolOccurrence.getLocation().getUri();
        Range range = symbolOccurrence.getLocation().getRange();
        OccurrenceType occurrenceType = symbolOccurrence.getOccurrenceType();
        return this.getSourceDefinedSymbol(symbolOccurrence.getSymbol()).map(symbol -> {
            SourceDefinedSymbol from = this.getFromSymbol(symbolOccurrence);
            return new Reference(from, (com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol)symbol, uri, range, occurrenceType);
        }).filter(ReferenceIndex::isReferenceAccessible);
    }

    private Optional<SourceDefinedSymbol> getSourceDefinedSymbol(Symbol symbolEntity) {
        String mdoRef = symbolEntity.getMdoRef();
        ModuleType moduleType = symbolEntity.getModuleType();
        String symbolName = symbolEntity.getSymbolName();
        return this.serverContext.getDocument(mdoRef, moduleType).map(DocumentContext::getSymbolTree).flatMap(symbolTree -> symbolTree.getMethodSymbol(symbolName));
    }

    private SourceDefinedSymbol getFromSymbol(SymbolOccurrence symbolOccurrence) {
        URI uri = symbolOccurrence.getLocation().getUri();
        Position position = symbolOccurrence.getLocation().getRange().getStart();
        Optional<SymbolTree> symbolTree = Optional.ofNullable(this.serverContext.getDocument(uri)).map(DocumentContext::getSymbolTree);
        return symbolTree.map(SymbolTree::getChildrenFlat).stream().flatMap(Collection::stream).filter(sourceDefinedSymbol -> sourceDefinedSymbol.getSymbolKind() != SymbolKind.Namespace).filter(symbol -> Ranges.containsPosition(symbol.getRange(), position)).findFirst().or(() -> symbolTree.map(SymbolTree::getModule)).orElseThrow();
    }

    private static boolean isReferenceAccessible(Reference reference) {
        if (!reference.isSourceDefinedSymbolReference()) {
            return true;
        }
        SourceDefinedSymbol to = reference.getSourceDefinedSymbol().orElseThrow();
        SourceDefinedSymbol from = reference.getFrom();
        if (to.getOwner().equals(from.getOwner())) {
            return true;
        }
        if (to instanceof Exportable) {
            return ((Exportable)((Object)to)).isExport();
        }
        return true;
    }

    @ConstructorProperties(value={"serverContext", "locationRepository", "symbolOccurrenceRepository"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReferenceIndex(ServerContext serverContext, LocationRepository locationRepository, SymbolOccurrenceRepository symbolOccurrenceRepository) {
        this.serverContext = serverContext;
        this.locationRepository = locationRepository;
        this.symbolOccurrenceRepository = symbolOccurrenceRepository;
    }
}

