/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.GenericIssueReport;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenericIssueReporter
implements DiagnosticReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericIssueReporter.class);
    private final Map<String, DiagnosticInfo> diagnosticInfos;

    @Override
    public String key() {
        return "generic";
    }

    @Override
    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        GenericIssueReport report = new GenericIssueReport(analysisInfo, this.diagnosticInfos);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File reportFile = new File(outputDir.toFile(), "bsl-generic-json.json");
        mapper.writeValue(reportFile, (Object)report);
        LOGGER.info("Generic issue report saved to {}", (Object)reportFile.getCanonicalPath());
    }

    @ConstructorProperties(value={"diagnosticInfos"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GenericIssueReporter(Map<String, DiagnosticInfo> diagnosticInfos) {
        this.diagnosticInfos = diagnosticInfos;
    }
}

