/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

@JacksonXmlRootElement(localName="testsuites")
class JUnitTestSuites {
    @JsonProperty(value="package")
    @JacksonXmlProperty(isAttribute=true)
    private final String name;
    @JacksonXmlElementWrapper(useWrapping=false)
    private final List<JUnitTestSuite> testsuite;

    public JUnitTestSuites(AnalysisInfo analysisInfo) {
        this.name = "bsl-language-server";
        this.testsuite = analysisInfo.getFileinfos().stream().filter(fileInfo -> !fileInfo.getDiagnostics().isEmpty()).map(JUnitTestSuite::new).collect(Collectors.toList());
    }

    public JUnitTestSuites(@JsonProperty(value="package") String name, @JsonProperty(value="testsuite") List<JUnitTestSuite> testsuite) {
        this.name = name;
        this.testsuite = new ArrayList<JUnitTestSuite>(testsuite);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<JUnitTestSuite> getTestsuite() {
        return this.testsuite;
    }

    static class JUnitFailureDeserializer
    extends JsonDeserializer<JUnitFailure> {
        JUnitFailureDeserializer() {
        }

        public JUnitFailure deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String type = node.get("type").asText("");
            String message = node.get("message").asText("");
            String value = node.get("").asText("");
            return new JUnitFailure(type, message, value);
        }
    }

    @JsonDeserialize(using=JUnitFailureDeserializer.class)
    static final class JUnitFailure {
        @JacksonXmlProperty(isAttribute=true)
        private final String type;
        @JacksonXmlProperty(isAttribute=true)
        private final String message;
        @JacksonXmlText
        @JacksonXmlCData
        private final String value;

        @ConstructorProperties(value={"type", "message", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public JUnitFailure(String type, String message, String value) {
            this.type = type;
            this.message = message;
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMessage() {
            return this.message;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JUnitFailure)) {
                return false;
            }
            JUnitFailure other = (JUnitFailure)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "JUnitTestSuites.JUnitFailure(type=" + this.getType() + ", message=" + this.getMessage() + ", value=" + this.getValue() + ")";
        }
    }

    static final class JUnitTestCase {
        @JacksonXmlProperty(isAttribute=true)
        private final String name;
        @JacksonXmlProperty(isAttribute=true)
        private final String classname;
        @JacksonXmlElementWrapper(useWrapping=false)
        private final JUnitFailure failure;

        public JUnitTestCase(List<Diagnostic> diagnostics, String name, String classname) {
            this.name = name;
            this.classname = classname;
            ArrayList<String> value = new ArrayList<String>();
            String type = "";
            String message = "";
            for (Diagnostic diagnostic : diagnostics) {
                type = diagnostic.getSeverity().toString().toLowerCase(Locale.ENGLISH);
                Position startRange = diagnostic.getRange().getStart();
                message = diagnostic.getMessage();
                value.add(String.format("line: %d, column: %d, text: %s", startRange.getLine() + 1, startRange.getCharacter(), diagnostic.getMessage()));
            }
            this.failure = new JUnitFailure(type, message, String.join((CharSequence)System.lineSeparator(), value));
        }

        public JUnitTestCase(@JsonProperty(value="name") String name, @JsonProperty(value="classname") String classname, @JsonProperty(value="failure") JUnitFailure failure) {
            this.name = name;
            this.classname = classname;
            this.failure = failure;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getClassname() {
            return this.classname;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public JUnitFailure getFailure() {
            return this.failure;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JUnitTestCase)) {
                return false;
            }
            JUnitTestCase other = (JUnitTestCase)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$classname = this.getClassname();
            String other$classname = other.getClassname();
            if (this$classname == null ? other$classname != null : !this$classname.equals(other$classname)) {
                return false;
            }
            JUnitFailure this$failure = this.getFailure();
            JUnitFailure other$failure = other.getFailure();
            return !(this$failure == null ? other$failure != null : !((Object)this$failure).equals(other$failure));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $classname = this.getClassname();
            result = result * 59 + ($classname == null ? 43 : $classname.hashCode());
            JUnitFailure $failure = this.getFailure();
            result = result * 59 + ($failure == null ? 43 : ((Object)$failure).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "JUnitTestSuites.JUnitTestCase(name=" + this.getName() + ", classname=" + this.getClassname() + ", failure=" + this.getFailure() + ")";
        }
    }

    static final class JUnitTestSuite {
        @JacksonXmlProperty(isAttribute=true)
        private final String name;
        @JacksonXmlElementWrapper(useWrapping=false)
        private final List<JUnitTestCase> testcase;

        public JUnitTestSuite(FileInfo fileInfo) {
            this.name = fileInfo.getPath().toString();
            this.testcase = new ArrayList<JUnitTestCase>();
            List<Diagnostic> diagnostics = fileInfo.getDiagnostics();
            Map groupedDiagnostics = diagnostics.stream().collect(Collectors.groupingBy(Diagnostic::getCode, Collectors.toList()));
            groupedDiagnostics.forEach((code, diagnosticsList) -> this.testcase.add(new JUnitTestCase((List<Diagnostic>)diagnosticsList, DiagnosticCode.getStringValue((Either<String, Integer>)code), this.name)));
        }

        public JUnitTestSuite(@JsonProperty(value="name") String name, @JsonProperty(value="testcase") List<JUnitTestCase> testcase) {
            this.name = name;
            this.testcase = new ArrayList<JUnitTestCase>(testcase);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<JUnitTestCase> getTestcase() {
            return this.testcase;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JUnitTestSuite)) {
                return false;
            }
            JUnitTestSuite other = (JUnitTestSuite)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<JUnitTestCase> this$testcase = this.getTestcase();
            List<JUnitTestCase> other$testcase = other.getTestcase();
            return !(this$testcase == null ? other$testcase != null : !((Object)this$testcase).equals(other$testcase));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<JUnitTestCase> $testcase = this.getTestcase();
            result = result * 59 + ($testcase == null ? 43 : ((Object)$testcase).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "JUnitTestSuites.JUnitTestSuite(name=" + this.getName() + ", testcase=" + this.getTestcase() + ")";
        }
    }
}

