/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ReportersAggregator {
    @Autowired
    private final List<DiagnosticReporter> reporters;
    @Autowired
    @Qualifier(value="filteredReporters")
    @Lazy
    private final List<DiagnosticReporter> filteredReporters;

    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        this.filteredReporters.forEach(diagnosticReporter -> diagnosticReporter.report(analysisInfo, outputDir));
    }

    public List<String> reporterKeys() {
        return this.reporters.stream().map(DiagnosticReporter::key).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"reporters", "filteredReporters"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReportersAggregator(List<DiagnosticReporter> reporters, List<DiagnosticReporter> filteredReporters) {
        this.reporters = reporters;
        this.filteredReporters = filteredReporters;
    }
}

