/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class TSLintReportEntry {
    private final EntryPosition startPosition;
    private final EntryPosition endPosition;
    private final String failure;
    private final String name;
    private final String ruleName;
    private final String ruleSeverity;
    private static final Map<DiagnosticSeverity, String> severityMap = new EnumMap<DiagnosticSeverity, String>(DiagnosticSeverity.class);

    TSLintReportEntry(String fileName, Diagnostic diagnostic) {
        this.endPosition = new EntryPosition(diagnostic.getRange().getEnd());
        this.failure = diagnostic.getMessage();
        this.name = fileName;
        this.ruleName = DiagnosticCode.getStringValue((Either<String, Integer>)diagnostic.getCode());
        this.ruleSeverity = severityMap.get(diagnostic.getSeverity());
        this.startPosition = new EntryPosition(diagnostic.getRange().getStart());
    }

    public TSLintReportEntry(@JsonProperty(value="startPosition") EntryPosition startPosition, @JsonProperty(value="endPosition") EntryPosition endPosition, @JsonProperty(value="failure") String failure, @JsonProperty(value="name") String name, @JsonProperty(value="ruleName") String ruleName, @JsonProperty(value="rileSeverity") String ruleSeverity) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.failure = failure;
        this.name = name;
        this.ruleName = ruleName;
        this.ruleSeverity = ruleSeverity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EntryPosition getStartPosition() {
        return this.startPosition;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EntryPosition getEndPosition() {
        return this.endPosition;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFailure() {
        return this.failure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRuleSeverity() {
        return this.ruleSeverity;
    }

    static {
        severityMap.put(DiagnosticSeverity.Error, "error");
        severityMap.put(DiagnosticSeverity.Hint, "warn");
        severityMap.put(DiagnosticSeverity.Information, "warn");
        severityMap.put(DiagnosticSeverity.Warning, "warn");
    }

    static class EntryPosition {
        private final int character;
        private final int line;
        private final int position;

        EntryPosition(Position position) {
            this.line = position.getLine();
            this.character = position.getCharacter();
            this.position = position.getCharacter();
        }

        public EntryPosition(@JsonProperty(value="character") int character, @JsonProperty(value="line") int line, @JsonProperty(value="position") int position) {
            this.character = character;
            this.line = line;
            this.position = position;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getCharacter() {
            return this.character;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getLine() {
            return this.line;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getPosition() {
            return this.position;
        }
    }
}

