/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public final class MultilingualStringAnalyser {
    private static final String NSTR_METHOD_NAME = "^(\u041d\u0421\u0442\u0440|NStr)";
    private static final String TEMPLATE_METHOD_NAME = "^(\u0421\u0442\u0440\u0428\u0430\u0431\u043b\u043e\u043d|StrTemplate)";
    private static final String NSTR_LANG_REGEX = "\\w+\\s*=\\s*['|\"{2}]";
    private static final String NSTR_LANG_CUT_REGEX = "\\s*=\\s*['|\"{2}]";
    private static final String WHITE_SPACE_REGEX = "\\s";
    private static final Pattern NSTR_METHOD_NAME_PATTERN = CaseInsensitivePattern.compile((String)"^(\u041d\u0421\u0442\u0440|NStr)");
    private static final Pattern TEMPLATE_METHOD_NAME_PATTERN = CaseInsensitivePattern.compile((String)"^(\u0421\u0442\u0440\u0428\u0430\u0431\u043b\u043e\u043d|StrTemplate)");
    private static final Pattern NSTR_LANG_PATTERN = CaseInsensitivePattern.compile((String)"\\w+\\s*=\\s*['|\"{2}]");
    private static final Pattern NSTR_LANG_CUT_PATTERN = CaseInsensitivePattern.compile((String)"\\s*=\\s*['|\"{2}]");
    private static final Pattern WHITE_SPACE_PATTERN = CaseInsensitivePattern.compile((String)"\\s");
    private BSLParser.GlobalMethodCallContext globalMethodCallContext;
    private boolean isParentTemplate;
    private String variableName;
    private final ArrayList<String> expectedLanguages;
    private final Set<String> expandedMultilingualString = new HashSet<String>();
    private ArrayList<String> missingLanguages = new ArrayList();

    public MultilingualStringAnalyser(String declaredLanguages) {
        Matcher matcher = WHITE_SPACE_PATTERN.matcher(declaredLanguages);
        this.expectedLanguages = new ArrayList<String>(Arrays.asList(matcher.replaceAll("").split(",")));
    }

    private static boolean isNotMultilingualString(BSLParser.GlobalMethodCallContext globalMethodCallContext) {
        String firstParameterMultilingualString = MultilingualStringAnalyser.getMultilingualString(globalMethodCallContext);
        return !firstParameterMultilingualString.isEmpty() && !firstParameterMultilingualString.startsWith("\"") || !NSTR_METHOD_NAME_PATTERN.matcher(globalMethodCallContext.methodName().getText()).find();
    }

    private static boolean hasTemplateInParents(ParserRuleContext globalMethodCallContext) {
        ParserRuleContext parent = globalMethodCallContext.getParent();
        if (parent instanceof BSLParser.FileContext || parent instanceof BSLParser.StatementContext) {
            return false;
        }
        if (parent instanceof BSLParser.GlobalMethodCallContext && MultilingualStringAnalyser.isTemplate((BSLParser.GlobalMethodCallContext)parent)) {
            return true;
        }
        return MultilingualStringAnalyser.hasTemplateInParents(parent);
    }

    private static boolean isTemplate(BSLParser.GlobalMethodCallContext parent) {
        return TEMPLATE_METHOD_NAME_PATTERN.matcher(parent.methodName().getText()).find();
    }

    private static String getVariableName(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.LValueContext lValue;
        BSLParser.AssignmentContext assignment = (BSLParser.AssignmentContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, 78);
        if (assignment != null && (lValue = assignment.lValue()) != null) {
            return lValue.getText();
        }
        return null;
    }

    public boolean parse(BSLParser.GlobalMethodCallContext ctx) {
        this.expandedMultilingualString.clear();
        this.missingLanguages.clear();
        this.isParentTemplate = false;
        if (MultilingualStringAnalyser.isNotMultilingualString(ctx)) {
            return false;
        }
        this.globalMethodCallContext = ctx;
        this.isParentTemplate = MultilingualStringAnalyser.hasTemplateInParents((ParserRuleContext)ctx);
        this.variableName = MultilingualStringAnalyser.getVariableName(ctx);
        this.expandMultilingualString();
        this.checkDeclaredLanguages();
        return true;
    }

    private void expandMultilingualString() {
        Matcher matcher = NSTR_LANG_PATTERN.matcher(MultilingualStringAnalyser.getMultilingualString(this.globalMethodCallContext));
        while (matcher.find()) {
            Matcher cutMatcher = NSTR_LANG_CUT_PATTERN.matcher(matcher.group());
            String langKey = cutMatcher.replaceAll("");
            this.expandedMultilingualString.add(langKey);
        }
    }

    private static String getMultilingualString(BSLParser.GlobalMethodCallContext globalMethodCallContext) {
        return globalMethodCallContext.doCall().callParamList().callParam(0).getText();
    }

    private void checkDeclaredLanguages() {
        if (this.expandedMultilingualString.isEmpty()) {
            this.missingLanguages = new ArrayList<String>(this.expectedLanguages);
            return;
        }
        for (String lang : this.expectedLanguages) {
            if (this.expandedMultilingualString.contains(lang)) continue;
            this.missingLanguages.add(lang);
        }
    }

    public boolean hasNotAllDeclaredLanguages() {
        return !this.missingLanguages.isEmpty();
    }

    public String getMissingLanguages() {
        return this.missingLanguages.toString();
    }

    public boolean isParentTemplate() {
        return this.isParentTemplate || this.istVariableUsingInTemplate();
    }

    private boolean istVariableUsingInTemplate() {
        if (this.variableName == null) {
            return false;
        }
        BSLParser.CodeBlockContext codeBlock = this.getCodeBlock();
        if (codeBlock == null) {
            return false;
        }
        return Trees.findAllRuleNodes((ParseTree)codeBlock, 90).stream().filter(node -> ((BSLParser.GlobalMethodCallContext)node).getStart().getLine() > this.globalMethodCallContext.getStart().getLine()).filter(node -> MultilingualStringAnalyser.isTemplate((BSLParser.GlobalMethodCallContext)node)).map(node -> ((BSLParser.GlobalMethodCallContext)node).doCall().callParamList()).filter(Objects::nonNull).map(BSLParser.CallParamListContext::callParam).filter(cp -> !cp.isEmpty()).anyMatch(cp -> cp.stream().anyMatch(p -> p.getText().equalsIgnoreCase(this.variableName)));
    }

    private BSLParser.CodeBlockContext getCodeBlock() {
        return (BSLParser.CodeBlockContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)this.globalMethodCallContext, 69);
    }
}

