/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils.expressiontree;

import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.DefaultNodeEqualityComparer;

public class TransitiveOperationsIgnoringComparer
extends DefaultNodeEqualityComparer {
    private boolean logicalsAreTransitive = false;

    @Override
    protected boolean binaryOperationsEqual(BinaryOperationNode first, BinaryOperationNode second) {
        if (first.getOperator() != second.getOperator()) {
            return false;
        }
        BslOperator operator = first.getOperator();
        if (this.isTransitiveOperation(operator)) {
            return super.binaryOperationsEqual(first, second) || this.areEqual(first.getLeft(), second.getRight()) && this.areEqual(first.getRight(), second.getLeft());
        }
        return super.binaryOperationsEqual(first, second);
    }

    public void logicalOperationsAsTransitive(boolean transitivityFlag) {
        this.logicalsAreTransitive = transitivityFlag;
    }

    private boolean isTransitiveOperation(BslOperator operator) {
        if (operator == BslOperator.DEREFERENCE || operator == BslOperator.INDEX_ACCESS) {
            return false;
        }
        return operator == BslOperator.ADD || operator == BslOperator.EQUAL || operator == BslOperator.MULTIPLY || this.isTransitiveLogicalOp(operator);
    }

    private boolean isTransitiveLogicalOp(BslOperator operator) {
        return this.logicalsAreTransitive && (operator == BslOperator.AND || operator == BslOperator.OR);
    }
}

