# Пропущен постфикс "Клиент" (CommonModuleNameClient)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                            Теги                            |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Незначительный` |              `Да`              |                 `5`                 |       `standard`<br>`badpractice`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Клиентские общие модули содержат клиентскую бизнес-логику (функциональность, определенную только для клиента)
 и имеют признаки:

* Клиент (управляемое приложение)
* Клиент (обычное приложение)

Исключение составляют случаи, когда клиентские процедуры и функции должны быть доступны только в режиме управляемого 
приложения (только в режиме обычного приложения или только в режиме внешнего соединения). 
В таких случаях, допустима иная комбинация двух этих признаков.

Клиентские общие модули именуются с постфиксом "Клиент" (англ. "Client" ). Кроме случая - когда стоит флаг Глобальный.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

РаботаСФайламиКлиент, ОбщегоНазначенияКлиент, StandardSubsystemsClient

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


[Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:469:hdoc:2.3)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CommonModuleNameClient-off
// BSLLS:CommonModuleNameClient-on
```

### Параметр конфигурационного файла

```json
"CommonModuleNameClient": false
```
