# Имя функции не должно начинаться с "Получить" (FunctionNameStartsWithGet)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Информационный` |             `Нет`              |                 `3`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В имени функции слово получить лишнее т.к. функция по определению возвращает значение.

## Примеры
```bsl
// Не правильно: 
Функция ПолучитьИмяПоКоду()

// Правильно: 
Функция ИмяПоКоду()
```


## Источники
* Источник: [Стандарт: Имена процедур и функций п 6.1](https://its.1c.ru/db/v8std#content:647:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:FunctionNameStartsWithGet-off
// BSLLS:FunctionNameStartsWithGet-on
```

### Параметр конфигурационного файла

```json
"FunctionNameStartsWithGet": false
```
