# Исходящий параметр функции (FunctionOutParameter)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |   Теги   |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:--------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |             `Нет`              |                `10`                 | `design` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Функция не должна иметь выходных параметров. Весь вывод должен быть в возвращаемом значении. Если нужно возвращать несколько значений следует использовать такие типы как Структура, Массив и т.д.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
// Не правильно: 
URLСервиса = "";
ИмяПользователя = "";
ПарольПользователя = "";

ЗаполнитьПараметрыПодключения(URLСервиса, ИмяПользователя, Пароль);

// Правильно: 
ПараметрыПодключения = НовыеПараметрыПодключения();
// Возвращаемое значение - Структура:
//     URLСервиса         - Строка
//     ИмяПользователя    - Строка
//     ПарольПользователя - Строка
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:FunctionOutParameter-off
// BSLLS:FunctionOutParameter-on
```

### Параметр конфигурационного файла

```json
"FunctionOutParameter": false
```
