# Конфликт имен методов с методами глобального контекста (GlobalContextMethodCollision8312)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги               |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:--------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Блокирующий` |              `Да`              |                `10`                 |    `error`<br>`unpredictable`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Начиная с версии платформы `8.3.12`, реализованы новые методы глобального контекста, которые могут совпаcть по имени с существующими функциями в коде конфигурации прикладного решений.

Метод|Английский вариант
:-: | :-:
ПроверитьБит|CheckBit
ПроверитьПоБитовойМаске|CheckByBitMask
УстановитьБит|SetBit
ПобитовоеИ|BitwiseAnd
ПобитовоеИли|BitwiseOr
ПобитовоеНе|BitwiseNot
ПобитовоеИНе|BitwiseAndNot
ПобитовоеИсключительноеИли|BitwiseXor
ПобитовыйСдвигВлево|BitwiseShiftLeft
ПобитовыйСдвигВправо|BitwiseShiftRight

Необходимо существующие функции конфигурации прикладного решения необходимо либо переименовать, либо удалить, заменив обращение к ним на методы глобального контекста.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* Источник: [Перевод конфигураций на платформу "1С:Предприятие 8.3" без режима совместимости с версией 8.2](https://its.1c.ru/db/metod8dev#content:5293:hdoc:pereimenovaniya_metodov_i_svojstv)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:GlobalContextMethodCollision8312-off
// BSLLS:GlobalContextMethodCollision8312-on
```

### Параметр конфигурационного файла

```json
"GlobalContextMethodCollision8312": false
```
