# Неправильный перенос выражения (IncorrectLineBreak)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Информационный` |              `Да`              |                 `2`                 |    `standard`<br>`badpractice`    |

## Параметры


|             Имя              |   Тип    |                                                           Описание                                                           |    Значение<br>по умолчанию    |
|:----------------------------:|:--------:|:----------------------------------------------------------------------------------------------------------------------------:|:------------------------------:|
|      `checkFirstSymbol`      | `Булево` |                                      `Проверять начало строки на некорректные символы`                                       |             `true`             |
| `listOfIncorrectFirstSymbol` | `Строка` |   `Символы через вертикальную черту, с которых не должна начинаться строка (специальные символы должны быть экранированы)`   |          `\)|;|,|\);`          |
|      `checkLastSymbol`       | `Булево` |                                       `Проверять конец строки на некорректные символы`                                       |             `true`             |
| `listOfIncorrectLastSymbol`  | `Строка` | `Символы через вертикальную черту, на которые не должна заканчиваться строка (специальные символы должны быть экранированы)` |   `ИЛИ|И|OR|AND|\+|-|/|%|\*`   |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Длинные арифметические выражения переносятся следующим образом:
в одной строке может находиться более одного операнда;
при переносе знаки операции пишутся в начале строки (а не в конце предыдущей строки);
операнды на новой строке предваряются стандартным отступом, либо выравниваются по началу первого операнда без учета знаков операций.

При необходимости параметры процедур, функций и методов следует переносить следующим образом:

* параметры выравниваются по началу первого параметра, либо предваряются стандартным отступом;
* закрывающая скобка и разделитель операторов ";" пишутся в той же строке, что и последний параметр;
* также допустим и способ форматирования, который предлагает функция автоформатирования в конфигураторе

Сложные логические условия в Если…ИначеЕсли…КонецЕсли следует переносить следующим образом:

* каждое элементарное условие нужно начинать с новой строки, если длина строки превышает ограничение в 120 символов;
* логические операторы И, ИЛИ ставятся в начале строки, а не в конце предыдущей строки;
* все условия предваряются стандартным отступом, либо выравниваются по началу первого условия, без учета логического оператора (для выравнивания выражений относительно первой строки рекомендуется использовать пробелы).

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
СуммаДокумента = СуммаБезСкидки +
                 СуммаРучнойСкидки +
                 СуммаАвтоматическойСкидки;
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* Источник: [Стандарт: Перенос выражений](https://its.1c.ru/db/v8std#content:444:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:IncorrectLineBreak-off
// BSLLS:IncorrectLineBreak-on
```

### Параметр конфигурационного файла

```json
"IncorrectLineBreak": {
    "checkFirstSymbol": true,
    "listOfIncorrectFirstSymbol": "\\)|;|,|\\);",
    "checkLastSymbol": true,
    "listOfIncorrectLastSymbol": "ИЛИ|И|OR|AND|\\+|-|/|%|\\*"
}
```
