# Все объявления переменных должны иметь описание (MissingVariablesDescription)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `1`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Все переменные модулей, а также все экспортируемые переменные должны иметь комментарии.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно:

```bsl
Перем Контекст;
```

Правильно:

```bsl
Перем Контекст; // Некое подробное описание, которое объясняет назначение переменной

// Некое подробное описание, которое объясняет назначение переменной
Перем Контекст;
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* Источник: [Соглашения при написания кода. Структура модуля](https://its.1c.ru/db/v8std#content:455:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingVariablesDescription-off
// BSLLS:MissingVariablesDescription-on
```

### Параметр конфигурационного файла

```json
"MissingVariablesDescription": false
```
