# Нарушение парности использования методов "НачатьТранзакцию()" и "ЗафиксироватьТранзакцию()" / "ОтменитьТранзакцию()" (PairingBrokenTransaction)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                `15`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Начало транзакции и ее фиксация (отмена) должны происходить в контексте одного метода.

## Примеры

*Правильно*

```bsl
Процедура ЗаписатьДанныеВИБ()

    НачатьТранзакцию();

    Попытка
        ... // чтение или запись данных
        ДокументОбъект.Записать()
        ЗафиксироватьТранзакцию();
    Исключение
        ОтменитьТранзакцию();
        ... // дополнительные действия по обработке исключения
    КонецПопытки;

КонецПроцедуры
```

*Неправильно*

```bsl
Процедура ЗаписатьДанныеВИБ()
 
    НачатьТранзакцию();
    ЗаписатьДокумент();

КонецПроцедуры;

Процедура ЗаписатьДокумент()

    Попытка
        ... // чтение или запись данных
        ДокументОбъект.Записать()
        ЗафиксироватьТранзакцию();
    Исключение
        ОтменитьТранзакцию();
    ... // дополнительные действия по обработке исключения
    КонецПопытки;

КонецПроцедуры

```

## Источники

* [Транзакции: правила использования](https://its.1c.ru/db/v8std#content:783:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:PairingBrokenTransaction-off
// BSLLS:PairingBrokenTransaction-on
```

### Параметр конфигурационного файла

```json
"PairingBrokenTransaction": false
```
