# Все методы программного интерфейса должны иметь описание (PublicMethodsDescription)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                            Теги                            |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------------------------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Информационный` |              `Да`              |                 `1`                 |       `standard`<br>`brainoverload`<br>`badpractice`       |

## Параметры


|       Имя        |   Тип    |                             Описание                              |    Значение<br>по умолчанию    |
|:----------------:|:--------:|:-----------------------------------------------------------------:|:------------------------------:|
| `checkAllRegion` | `Булево` | `Проверять методы без учета областей в которых они располагаются` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
Все экспортные методы, располагающиеся в областях программного интерфейса, должны иметь описание.

## Источники
* [Стандарт "Описание процедур и функций". Пункт 2](https://its.1c.ru/db/v8std#content:453:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:PublicMethodsDescription-off
// BSLLS:PublicMethodsDescription-on
```

### Параметр конфигурационного файла

```json
"PublicMethodsDescription": {
    "checkAllRegion": false
}
```
