# Обращение к несуществующим метаданным в запросе (WrongMetadataInQuery)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |            Теги             |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:---------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Блокирующий` |              `Да`              |                 `5`                 |    `suspicious`<br>`sql`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При доработке кода 1С и изменения модели метаданных нередко остаются неверные запросы, в которых идет обращение к таблице метаданного, которую или переименовали или удалили.
Также ошибочные имена таблиц могут возникать при ручном изменения запросов, без использования конструктора запросов.
Конфигуратор и EDT выполняют проверки кода на правильность при изменении метаданных, но эти проверки могут быть пропущены.

Поэтому нужно контролировать правильность обращения к метаданным внутри текстов запросов.

При выполнении подобных запросов будет возникать ошибка исполнения.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Пример запроса с неверным именем таблицы
```sdbl
ВЫБРАТЬ
	Таблица.РесурсЧисло КАК РесурсЧисло
ИЗ
	РегистрСведений.УстаревшееИмяРегистра КАК Таблица
```
или пример запроса с неверным именем таблицы внутри соединения
```sdbl
ВЫБРАТЬ
	Таблица.РесурсЧисло КАК РесурсЧисло
ИЗ
	РегистрСведений.Регистр1 КАК Таблица
	ВНУТРЕННЕЕ СОЕДИНЕНИЕ РегистрСведений.УстаревшееИмяРегистра КАК ТаблицаФильтр
	ПО ТаблицаФильтр.Регистратор = Таблица.Регистратор
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Работа с запросами - стандарты разработки 1С](https://its.1c.ru/db/v8std#browse:13:-1:26:27)
- [Оптимизация запросов - стандарты разработки 1С](https://its.1c.ru/db/v8std#browse:13:-1:26:28)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:WrongMetadataInQuery-off
// BSLLS:WrongMetadataInQuery-on
```

### Параметр конфигурационного файла

```json
"WrongMetadataInQuery": false
```
