/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop.sentry;

import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.SendErrorsMode;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PermissionFilterBeforeSendCallback
implements SentryOptions.BeforeSendCallback {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionFilterBeforeSendCallback.class);
    private static final Map<Language, Map<String, SendErrorsMode>> answers = PermissionFilterBeforeSendCallback.createAnswersMap();
    private final LanguageServerConfiguration configuration;
    private final LanguageClientHolder languageClientHolder;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private final ServerInfo serverInfo;
    private final AtomicBoolean questionWasSend = new AtomicBoolean(false);

    public SentryEvent execute(SentryEvent event, Hint hint) {
        if (this.sendToSentry()) {
            return event;
        }
        return null;
    }

    private boolean sendToSentry() {
        SendErrorsMode currentErrorsMode;
        boolean result;
        if (this.configuration.getSendErrors() == SendErrorsMode.ASK) {
            if (!this.languageClientHolder.isConnected() || this.clientCapabilitiesHolder.getCapabilities().isEmpty()) {
                return false;
            }
            if (!this.questionWasSend.compareAndSet(false, true)) {
                return false;
            }
            this.languageClientHolder.execIfConnected(languageClient -> {
                CompletableFuture<MessageActionItem> sendQuestion = this.askUserForPermission((LanguageClient)languageClient);
                MessageActionItem answerItem = this.waitForPermission(sendQuestion);
                Optional.ofNullable(answerItem).map(MessageActionItem::getTitle).map(title -> answers.get((Object)this.configuration.getLanguage()).get(title)).ifPresent(this.configuration::setSendErrors);
                this.questionWasSend.set(false);
            });
        }
        boolean bl = result = (currentErrorsMode = this.configuration.getSendErrors()) == SendErrorsMode.SEND || currentErrorsMode == SendErrorsMode.SEND_ONCE;
        if (currentErrorsMode == SendErrorsMode.SEND_ONCE) {
            this.configuration.setSendErrors(SendErrorsMode.ASK);
        }
        return result;
    }

    private CompletableFuture<MessageActionItem> askUserForPermission(LanguageClient languageClient) {
        String message = Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), "question", this.serverInfo.getName());
        List actions = answers.get((Object)this.configuration.getLanguage()).keySet().stream().map(MessageActionItem::new).collect(Collectors.toList());
        ShowMessageRequestParams requestParams = new ShowMessageRequestParams();
        requestParams.setType(MessageType.Error);
        requestParams.setMessage(message);
        requestParams.setActions(actions);
        return languageClient.showMessageRequest(requestParams);
    }

    @Nullable
    private MessageActionItem waitForPermission(CompletableFuture<MessageActionItem> sendQuestion) {
        try {
            return sendQuestion.get();
        }
        catch (InterruptedException e) {
            LOGGER.error("Can't wait for permission", (Throwable)e);
            this.questionWasSend.set(false);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Can't execute permission request", (Throwable)e);
            this.questionWasSend.set(false);
            throw new IllegalStateException(e);
        }
    }

    private static Map<Language, Map<String, SendErrorsMode>> createAnswersMap() {
        return Map.of(Language.EN, PermissionFilterBeforeSendCallback.getAnswersWithModes(Language.EN), Language.RU, PermissionFilterBeforeSendCallback.getAnswersWithModes(Language.RU));
    }

    private static Map<String, SendErrorsMode> getAnswersWithModes(Language language) {
        Class<PermissionFilterBeforeSendCallback> clazz = PermissionFilterBeforeSendCallback.class;
        LinkedHashMap<String, SendErrorsMode> map = new LinkedHashMap<String, SendErrorsMode>();
        map.put(Resources.getResourceString(language, clazz, "answer_sendOnce"), SendErrorsMode.SEND_ONCE);
        map.put(Resources.getResourceString(language, clazz, "answer_skip"), SendErrorsMode.ASK);
        map.put(Resources.getResourceString(language, clazz, "answer_send"), SendErrorsMode.SEND);
        map.put(Resources.getResourceString(language, clazz, "answer_dontSend"), SendErrorsMode.NEVER);
        return map;
    }

    @ConstructorProperties(value={"configuration", "languageClientHolder", "clientCapabilitiesHolder", "serverInfo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PermissionFilterBeforeSendCallback(LanguageServerConfiguration configuration, LanguageClientHolder languageClientHolder, ClientCapabilitiesHolder clientCapabilitiesHolder, ServerInfo serverInfo) {
        this.configuration = configuration;
        this.languageClientHolder = languageClientHolder;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
        this.serverInfo = serverInfo;
    }
}

