/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.aop.sentry;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sentry.Sentry;
import io.sentry.protocol.User;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.lsp4j.ServerInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"sentryHub"})
@DependsOn(value={"sentryHub"})
public class SentryScopeConfigurer {
    private final ServerInfo serverInfo;

    @PostConstruct
    public void init() {
        Sentry.configureScope(scope -> {
            User user = new User();
            user.setId(UUID.randomUUID().toString());
            scope.setUser(user);
            scope.setTag("server.version", this.serverInfo.getVersion());
        });
    }

    @ConstructorProperties(value={"serverInfo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SentryScopeConfigurer(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }
}

