/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cfg;

import com.github._1c_syntax.bsl.languageserver.cfg.BasicBlockVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdge;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdgeType;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ConditionalVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ControlFlowGraph;
import com.github._1c_syntax.bsl.languageserver.cfg.ExitVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ForLoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ForeachLoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.LabelVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.LoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.PreprocessorConditionVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.StatementsBlockWriter;
import com.github._1c_syntax.bsl.languageserver.cfg.TryExceptVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.WhileLoopVertex;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class CfgBuildingParseTreeVisitor
extends BSLParserBaseVisitor<ParseTree> {
    private StatementsBlockWriter blocks;
    private ControlFlowGraph graph;
    private Map<String, LabelVertex> jumpLabels;
    private boolean produceLoopIterationsEnabled = true;
    private boolean producePreprocessorConditionsEnabled = true;
    private boolean adjacentDeadCodeEnabled = false;

    public void produceLoopIterations(boolean enable) {
        this.produceLoopIterationsEnabled = enable;
    }

    public void producePreprocessorConditions(boolean enable) {
        this.producePreprocessorConditionsEnabled = enable;
    }

    public void determineAdjacentDeadCode(boolean enabled) {
        this.adjacentDeadCodeEnabled = enabled;
    }

    public ControlFlowGraph buildGraph(BSLParser.CodeBlockContext block) {
        this.blocks = new StatementsBlockWriter();
        this.graph = new ControlFlowGraph();
        this.jumpLabels = new HashMap<String, LabelVertex>();
        StatementsBlockWriter.JumpInformationRecord exitPoints = new StatementsBlockWriter.JumpInformationRecord();
        exitPoints.exceptionHandler = exitPoints.methodReturn = this.graph.getExitPoint();
        this.blocks.enterBlock(exitPoints);
        block.accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord builtBlock = this.blocks.leaveBlock();
        this.graph.addVertex(builtBlock.begin());
        this.graph.addVertex(builtBlock.end());
        this.connectGraphTail(builtBlock, exitPoints.methodReturn);
        this.removeOrphanedNodes();
        if (this.graph.containsVertex(builtBlock.begin())) {
            this.graph.setEntryPoint(builtBlock.begin());
        } else {
            this.graph.setEntryPoint(exitPoints.methodReturn);
        }
        return this.graph;
    }

    public ParseTree visitCallStatement(BSLParser.CallStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitWaitStatement(BSLParser.WaitStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitAssignment(BSLParser.AssignmentContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitIfStatement(BSLParser.IfStatementContext ctx) {
        ConditionalVertex conditionStatement = new ConditionalVertex(ctx.ifBranch());
        this.graph.addVertex(conditionStatement);
        this.connectGraphTail(this.blocks.getCurrentBlock(), conditionStatement);
        this.blocks.enterBlock();
        StatementsBlockWriter.StatementsBlockRecord currentLevelBlock = this.blocks.getCurrentBlock();
        this.blocks.enterBlock();
        ctx.ifBranch().codeBlock().accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord truePart = this.blocks.leaveBlock();
        this.graph.addEdge(conditionStatement, truePart.begin(), CfgEdgeType.TRUE_BRANCH);
        currentLevelBlock.getBuildParts().push(truePart.end());
        currentLevelBlock.getBuildParts().push(conditionStatement);
        for (BSLParser.ElsifBranchContext elif : ctx.elsifBranch()) {
            elif.accept((ParseTreeVisitor)this);
        }
        if (ctx.elseBranch() != null) {
            ctx.elseBranch().accept((ParseTreeVisitor)this);
            conditionStatement = null;
        } else {
            conditionStatement = (ConditionalVertex)currentLevelBlock.getBuildParts().pop();
        }
        this.blocks.leaveBlock();
        StatementsBlockWriter.StatementsBlockRecord upperBlock = this.blocks.getCurrentBlock();
        upperBlock.split();
        this.graph.addVertex(upperBlock.end());
        if (conditionStatement != null) {
            this.graph.addEdge(conditionStatement, upperBlock.end(), CfgEdgeType.FALSE_BRANCH);
        }
        while (!currentLevelBlock.getBuildParts().isEmpty()) {
            BasicBlockVertex basicBlock;
            CfgVertex blockTail = currentLevelBlock.getBuildParts().pop();
            if (this.hasNoSignificantEdges(blockTail) && blockTail instanceof BasicBlockVertex && (basicBlock = (BasicBlockVertex)blockTail).statements().isEmpty()) continue;
            this.graph.addEdge(blockTail, upperBlock.end());
        }
        return ctx;
    }

    private boolean hasNoSignificantEdges(CfgVertex blockTail) {
        Set edges = this.graph.incomingEdgesOf(blockTail);
        return edges.isEmpty() || this.adjacentDeadCodeEnabled && edges.stream().allMatch(x -> x.getType() == CfgEdgeType.ADJACENT_CODE);
    }

    public ParseTree visitElsifBranch(BSLParser.ElsifBranchContext ctx) {
        CfgVertex previousCondition = this.blocks.getCurrentBlock().getBuildParts().pop();
        ConditionalVertex condition = new ConditionalVertex(ctx);
        this.graph.addVertex(condition);
        this.graph.addEdge(previousCondition, condition, CfgEdgeType.FALSE_BRANCH);
        this.blocks.enterBlock();
        ctx.codeBlock().accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord truePart = this.blocks.leaveBlock();
        this.graph.addEdge(condition, truePart.begin(), CfgEdgeType.TRUE_BRANCH);
        this.blocks.getCurrentBlock().getBuildParts().push(truePart.end());
        this.blocks.getCurrentBlock().getBuildParts().push(condition);
        return ctx;
    }

    public ParseTree visitCodeBlock(BSLParser.CodeBlockContext ctx) {
        StatementsBlockWriter.StatementsBlockRecord currentBlock = this.blocks.getCurrentBlock();
        this.graph.addVertex(currentBlock.begin());
        return (ParseTree)super.visitCodeBlock(ctx);
    }

    public ParseTree visitElseBranch(BSLParser.ElseBranchContext ctx) {
        this.blocks.enterBlock();
        ctx.codeBlock().accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord block = this.blocks.leaveBlock();
        CfgVertex condition = this.blocks.getCurrentBlock().getBuildParts().pop();
        this.graph.addEdge(condition, block.begin(), CfgEdgeType.FALSE_BRANCH);
        this.blocks.getCurrentBlock().getBuildParts().push(block.end());
        return ctx;
    }

    public ParseTree visitWhileStatement(BSLParser.WhileStatementContext ctx) {
        WhileLoopVertex loopStart = new WhileLoopVertex(ctx);
        this.buildLoopSubgraph(ctx.codeBlock(), loopStart);
        return ctx;
    }

    public ParseTree visitForStatement(BSLParser.ForStatementContext ctx) {
        ForLoopVertex loopStart = new ForLoopVertex(ctx);
        this.buildLoopSubgraph(ctx.codeBlock(), loopStart);
        return ctx;
    }

    public ParseTree visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        ForeachLoopVertex loopStart = new ForeachLoopVertex(ctx);
        this.buildLoopSubgraph(ctx.codeBlock(), loopStart);
        return ctx;
    }

    public ParseTree visitExecuteStatement(BSLParser.ExecuteStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitAddHandlerStatement(BSLParser.AddHandlerStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitRemoveHandlerStatement(BSLParser.RemoveHandlerStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitGotoStatement(BSLParser.GotoStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        String name = ctx.labelName().getText();
        LabelVertex labelVertex = this.createOrGetKnownLabel(name);
        StatementsBlockWriter.StatementsBlockRecord block = this.blocks.getCurrentBlock();
        CfgVertex currentTail = this.blocks.getCurrentBlock().end();
        this.connectGraphTail(block, labelVertex);
        block.split();
        this.graph.addVertex(block.end());
        this.connectAdjacentCode(currentTail);
        return ctx;
    }

    public ParseTree visitLabel(BSLParser.LabelContext ctx) {
        String name = ctx.labelName().getText();
        LabelVertex labelVertex = this.createOrGetKnownLabel(name);
        StatementsBlockWriter.StatementsBlockRecord block = this.blocks.getCurrentBlock();
        this.connectGraphTail(block, labelVertex);
        block.split();
        this.graph.addVertex(block.end());
        this.graph.addEdge(labelVertex, block.end());
        return ctx;
    }

    public ParseTree visitContinueStatement(BSLParser.ContinueStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        CfgVertex currentTail = this.blocks.getCurrentBlock().end();
        StatementsBlockWriter.JumpInformationRecord jumps = this.blocks.getCurrentBlock().getJumpContext();
        this.makeJump(jumps.loopContinue);
        this.connectAdjacentCode(currentTail);
        return ctx;
    }

    public ParseTree visitReturnStatement(BSLParser.ReturnStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        CfgVertex currentTail = this.blocks.getCurrentBlock().end();
        StatementsBlockWriter.JumpInformationRecord jumps = this.blocks.getCurrentBlock().getJumpContext();
        this.makeJump(jumps.methodReturn);
        this.connectAdjacentCode(currentTail);
        return ctx;
    }

    public ParseTree visitBreakStatement(BSLParser.BreakStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        CfgVertex currentTail = this.blocks.getCurrentBlock().end();
        StatementsBlockWriter.JumpInformationRecord jumps = this.blocks.getCurrentBlock().getJumpContext();
        this.makeJump(jumps.loopBreak);
        this.connectAdjacentCode(currentTail);
        return ctx;
    }

    public ParseTree visitTryStatement(BSLParser.TryStatementContext ctx) {
        TryExceptVertex tryBranch = new TryExceptVertex(ctx);
        this.graph.addVertex(tryBranch);
        this.connectGraphTail(this.blocks.getCurrentBlock(), tryBranch);
        this.blocks.enterBlock();
        this.blocks.enterBlock();
        ctx.exceptCodeBlock().accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord exception = this.blocks.leaveBlock();
        StatementsBlockWriter.JumpInformationRecord jumpInfo = new StatementsBlockWriter.JumpInformationRecord();
        jumpInfo.exceptionHandler = exception.begin();
        this.blocks.enterBlock(jumpInfo);
        ctx.tryCodeBlock().accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord success = this.blocks.leaveBlock();
        this.graph.addEdge(tryBranch, success.begin(), CfgEdgeType.TRUE_BRANCH);
        this.blocks.getCurrentBlock().getBuildParts().push(success.end());
        this.graph.addEdge(tryBranch, exception.begin(), CfgEdgeType.FALSE_BRANCH);
        this.blocks.getCurrentBlock().getBuildParts().push(exception.end());
        StatementsBlockWriter.StatementsBlockRecord builtBlock = this.blocks.leaveBlock();
        this.blocks.getCurrentBlock().split();
        this.graph.addVertex(this.blocks.getCurrentBlock().end());
        while (!builtBlock.getBuildParts().isEmpty()) {
            this.graph.addEdge(builtBlock.getBuildParts().pop(), this.blocks.getCurrentBlock().end());
        }
        return ctx;
    }

    public ParseTree visitRaiseStatement(BSLParser.RaiseStatementContext ctx) {
        this.blocks.addStatement((BSLParserRuleContext)ctx);
        CfgVertex currentTail = this.blocks.getCurrentBlock().end();
        StatementsBlockWriter.JumpInformationRecord jumps = this.blocks.getCurrentBlock().getJumpContext();
        this.makeJump(jumps.exceptionHandler);
        this.connectAdjacentCode(currentTail);
        return ctx;
    }

    public ParseTree visitPreproc_if(BSLParser.Preproc_ifContext ctx) {
        if (!this.producePreprocessorConditionsEnabled) {
            return ctx;
        }
        if (!this.isStatementLevelPreproc((BSLParserRuleContext)ctx)) {
            return (ParseTree)super.visitPreproc_if(ctx);
        }
        PreprocessorConditionVertex node = new PreprocessorConditionVertex(ctx);
        this.graph.addVertex(node);
        this.connectGraphTail(this.blocks.getCurrentBlock(), node);
        StatementsBlockWriter.StatementsBlockRecord mainIf = this.blocks.enterBlock();
        StatementsBlockWriter.StatementsBlockRecord body = this.blocks.enterBlock();
        this.graph.addVertex(body.begin());
        this.graph.addEdge(node, body.begin(), CfgEdgeType.TRUE_BRANCH);
        body.getBuildParts().push(node);
        mainIf.getBuildParts().push(body.begin());
        return (ParseTree)super.visitPreproc_if(ctx);
    }

    public ParseTree visitPreproc_else(BSLParser.Preproc_elseContext ctx) {
        if (!this.producePreprocessorConditionsEnabled) {
            return ctx;
        }
        PreprocessorConditionVertex condition = this.popPreprocCondition();
        if (condition == null) {
            return (ParseTree)super.visitPreproc_else(ctx);
        }
        StatementsBlockWriter.StatementsBlockRecord previousBody = this.blocks.leaveBlock();
        this.blocks.getCurrentBlock().getBuildParts().push(previousBody.end());
        StatementsBlockWriter.StatementsBlockRecord elseBody = this.blocks.enterBlock();
        this.graph.addVertex(elseBody.begin());
        this.graph.addEdge(condition, elseBody.begin(), CfgEdgeType.FALSE_BRANCH);
        elseBody.getBuildParts().push(condition);
        return ctx;
    }

    public ParseTree visitPreproc_elsif(BSLParser.Preproc_elsifContext ctx) {
        if (!this.producePreprocessorConditionsEnabled) {
            return ctx;
        }
        PreprocessorConditionVertex condition = this.popPreprocCondition();
        if (condition == null) {
            return (ParseTree)super.visitPreproc_elsif(ctx);
        }
        PreprocessorConditionVertex newCondition = new PreprocessorConditionVertex(ctx);
        this.graph.addVertex(newCondition);
        this.graph.addEdge(condition, newCondition, CfgEdgeType.FALSE_BRANCH);
        StatementsBlockWriter.StatementsBlockRecord previousBody = this.blocks.leaveBlock();
        this.blocks.getCurrentBlock().getBuildParts().push(previousBody.end());
        StatementsBlockWriter.StatementsBlockRecord body = this.blocks.enterBlock();
        this.graph.addVertex(body.begin());
        this.graph.addEdge(newCondition, body.begin(), CfgEdgeType.TRUE_BRANCH);
        body.getBuildParts().push(newCondition);
        return ctx;
    }

    public ParseTree visitPreproc_endif(BSLParser.Preproc_endifContext ctx) {
        if (!this.producePreprocessorConditionsEnabled) {
            return ctx;
        }
        PreprocessorConditionVertex condition = this.popPreprocCondition();
        if (condition == null) {
            return (ParseTree)super.visitPreproc_endif(ctx);
        }
        StatementsBlockWriter.StatementsBlockRecord previousBody = this.blocks.leaveBlock();
        StatementsBlockWriter.StatementsBlockRecord mainIf = this.blocks.leaveBlock();
        mainIf.getBuildParts().push(previousBody.end());
        StatementsBlockWriter.StatementsBlockRecord upperBlock = this.blocks.getCurrentBlock();
        upperBlock.split();
        this.graph.addVertex(upperBlock.end());
        if (this.graph.outgoingEdgesOf(condition).size() < 2) {
            this.graph.addEdge(condition, upperBlock.end(), CfgEdgeType.FALSE_BRANCH);
        }
        while (!mainIf.getBuildParts().isEmpty()) {
            BasicBlockVertex basicBlock;
            CfgVertex blockTail = mainIf.getBuildParts().pop();
            if (this.hasNoSignificantEdges(blockTail) && blockTail instanceof BasicBlockVertex && (basicBlock = (BasicBlockVertex)blockTail).statements().isEmpty()) {
                this.graph.removeVertex(basicBlock);
                continue;
            }
            this.graph.addVertex(blockTail);
            this.graph.addEdge(blockTail, upperBlock.end());
        }
        return ctx;
    }

    private boolean isStatementLevelPreproc(BSLParserRuleContext ctx) {
        return ctx.getParent().getParent().getRuleIndex() == 80;
    }

    private PreprocessorConditionVertex popPreprocCondition() {
        CfgVertex node = this.blocks.getCurrentBlock().getBuildParts().peek();
        if (node instanceof PreprocessorConditionVertex) {
            this.blocks.getCurrentBlock().getBuildParts().pop();
            return (PreprocessorConditionVertex)node;
        }
        return null;
    }

    private void connectAdjacentCode(CfgVertex currentTail) {
        if (this.adjacentDeadCodeEnabled) {
            CfgVertex newTail = this.blocks.getCurrentBlock().end();
            this.graph.addEdge(currentTail, newTail, CfgEdgeType.ADJACENT_CODE);
        }
    }

    private void makeJump(CfgVertex jumpTarget) {
        this.connectGraphTail(this.blocks.getCurrentBlock(), jumpTarget);
        this.blocks.getCurrentBlock().split();
        this.graph.addVertex(this.blocks.getCurrentBlock().end());
    }

    private void buildLoopSubgraph(BSLParser.CodeBlockContext ctx, LoopVertex loopStart) {
        this.graph.addVertex(loopStart);
        this.connectGraphTail(this.blocks.getCurrentBlock(), loopStart);
        this.blocks.getCurrentBlock().split();
        this.graph.addVertex(this.blocks.getCurrentBlock().end());
        StatementsBlockWriter.JumpInformationRecord jumpState = new StatementsBlockWriter.JumpInformationRecord();
        jumpState.loopContinue = loopStart;
        jumpState.loopBreak = this.blocks.getCurrentBlock().end();
        this.blocks.enterBlock(jumpState);
        ctx.accept((ParseTreeVisitor)this);
        StatementsBlockWriter.StatementsBlockRecord body = this.blocks.leaveBlock();
        this.graph.addEdge(loopStart, body.begin(), CfgEdgeType.TRUE_BRANCH);
        this.graph.addEdge(loopStart, this.blocks.getCurrentBlock().end(), CfgEdgeType.FALSE_BRANCH);
        if (this.produceLoopIterationsEnabled) {
            this.graph.addEdge(body.end(), loopStart, CfgEdgeType.LOOP_ITERATION);
        }
    }

    private void connectGraphTail(StatementsBlockWriter.StatementsBlockRecord currentBlock, CfgVertex vertex) {
        if (!(currentBlock.end() instanceof BasicBlockVertex)) {
            this.graph.addEdge(currentBlock.end(), vertex);
            return;
        }
        BasicBlockVertex currentTail = (BasicBlockVertex)currentBlock.end();
        if (currentTail.statements().isEmpty()) {
            Set incoming = this.graph.incomingEdgesOf(currentTail);
            for (CfgEdge edge : incoming) {
                if (edge.getType() == CfgEdgeType.ADJACENT_CODE) continue;
                CfgVertex source = (CfgVertex)this.graph.getEdgeSource((Object)edge);
                this.graph.addEdge(source, vertex, edge.getType());
            }
            this.graph.removeVertex(currentTail);
            currentBlock.replaceEnd(vertex);
        } else {
            this.graph.addEdge(currentBlock.end(), vertex);
        }
    }

    private void removeOrphanedNodes() {
        List<CfgVertex> orphans = this.graph.vertexSet().stream().filter(vertex -> !(vertex instanceof ExitVertex)).filter(vertex -> {
            ArrayList edges = new ArrayList(this.graph.edgesOf(vertex));
            return edges.isEmpty() || this.adjacentDeadCodeEnabled && edges.size() == 1 && ((CfgEdge)((Object)((Object)edges.get(0)))).getType() == CfgEdgeType.ADJACENT_CODE && this.graph.getEdgeTarget((Object)((CfgEdge)((Object)((Object)edges.get(0))))) == vertex;
        }).collect(Collectors.toList());
        orphans.forEach(x -> this.graph.removeVertex(x));
    }

    private LabelVertex createOrGetKnownLabel(String labelName) {
        LabelVertex labelVertex = this.jumpLabels.get(labelName);
        if (labelVertex == null) {
            labelVertex = new LabelVertex(labelName);
            this.jumpLabels.put(labelName, labelVertex);
            this.graph.addVertex(labelVertex);
        }
        return labelVertex;
    }
}

