/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cfg;

import com.github._1c_syntax.bsl.languageserver.cfg.BasicBlockVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgVertex;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayDeque;
import java.util.Deque;

class StatementsBlockWriter {
    private final Deque<StatementsBlockRecord> blocks = new ArrayDeque<StatementsBlockRecord>();

    StatementsBlockWriter() {
    }

    public int size() {
        return this.blocks.size();
    }

    public StatementsBlockRecord enterBlock() {
        return this.enterBlock(new JumpInformationRecord());
    }

    public StatementsBlockRecord enterBlock(JumpInformationRecord newJumpStates) {
        StatementsBlockRecord current = this.getCurrentBlock();
        if (current != null) {
            if (newJumpStates.methodReturn == null) {
                newJumpStates.methodReturn = current.jumpContext.methodReturn;
            }
            if (newJumpStates.loopBreak == null) {
                newJumpStates.loopBreak = current.jumpContext.loopBreak;
            }
            if (newJumpStates.loopContinue == null) {
                newJumpStates.loopContinue = current.jumpContext.loopContinue;
            }
            if (newJumpStates.exceptionHandler == null) {
                newJumpStates.exceptionHandler = current.jumpContext.exceptionHandler;
            }
        }
        StatementsBlockRecord block = new StatementsBlockRecord(newJumpStates);
        this.blocks.push(block);
        return block;
    }

    public StatementsBlockRecord leaveBlock() {
        return this.blocks.pop();
    }

    public StatementsBlockRecord getCurrentBlock() {
        return this.blocks.peek();
    }

    public void addStatement(BSLParserRuleContext statement) {
        this.getCurrentBlock().add(statement);
    }

    static class JumpInformationRecord {
        CfgVertex methodReturn;
        CfgVertex loopContinue;
        CfgVertex loopBreak;
        CfgVertex exceptionHandler;

        JumpInformationRecord() {
        }
    }

    static class StatementsBlockRecord {
        private CfgVertex subgraphBegin;
        private CfgVertex subgraphEnd;
        private BasicBlockVertex statements = new BasicBlockVertex();
        private final Deque<CfgVertex> buildStack = new ArrayDeque<CfgVertex>();
        private final JumpInformationRecord jumpContext;

        public StatementsBlockRecord() {
            this(new JumpInformationRecord());
        }

        public StatementsBlockRecord(JumpInformationRecord jumpInfo) {
            this.jumpContext = jumpInfo;
            this.subgraphBegin = this.statements;
            this.subgraphEnd = this.statements;
        }

        public void add(BSLParserRuleContext statement) {
            this.statements.addStatement(statement);
        }

        public Deque<CfgVertex> getBuildParts() {
            return this.buildStack;
        }

        public JumpInformationRecord getJumpContext() {
            return this.jumpContext;
        }

        public void split() {
            if (this.subgraphBegin instanceof BasicBlockVertex && this.subgraphBegin == this.subgraphEnd) {
                this.subgraphBegin = this.statements;
            }
            this.statements = new BasicBlockVertex();
            this.subgraphEnd = this.statements;
        }

        public CfgVertex begin() {
            return this.subgraphBegin;
        }

        public CfgVertex end() {
            return this.subgraphEnd;
        }

        public void replaceEnd(CfgVertex vertex) {
            if (this.subgraphBegin == this.subgraphEnd) {
                this.subgraphBegin = vertex;
            }
            this.subgraphEnd = vertex;
        }
    }
}

