/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.configuration.watcher;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.configuration.watcher.ConfigurationFileChangeListener;
import com.github._1c_syntax.utils.Absolute;
import com.sun.nio.file.SensitivityWatchEventModifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationFileSystemWatcher {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFileSystemWatcher.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final LanguageServerConfiguration configuration;
    private final ConfigurationFileChangeListener listener;
    private Path registeredPath;
    private WatchService watchService;
    private WatchKey watchKey;

    @PostConstruct
    public void init() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.registerWatchService(this.configuration.getConfigurationFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void onDestroy() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.watchKey.cancel();
            this.watchService.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=5000L)
    public void watch() {
        Object object = this.$lock;
        synchronized (object) {
            long lastModified = 0L;
            for (WatchEvent<?> watchEvent : this.watchKey.pollEvents()) {
                File file;
                Path context = (Path)watchEvent.context();
                if (context == null || !this.isConfigurationFile(file = new File(this.registeredPath.toFile(), context.toFile().getName())) || file.lastModified() == lastModified && !watchEvent.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                lastModified = file.lastModified();
                this.listener.onChange(file, watchEvent.kind());
            }
            this.watchKey.reset();
        }
    }

    @EventListener
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
        this.registerWatchService(event.getSource().getConfigurationFile());
    }

    private void registerWatchService(File configurationFile) {
        Path configurationDir = Absolute.path((File)configurationFile).getParent();
        if (configurationDir == null) {
            return;
        }
        if (configurationDir.equals(this.registeredPath)) {
            return;
        }
        if (this.watchKey != null) {
            this.watchKey.cancel();
        }
        this.registeredPath = configurationDir;
        this.watchKey = this.registeredPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        LOGGER.debug("Watch for configuration file changes in {}", (Object)configurationDir);
    }

    private boolean isConfigurationFile(File pathname) {
        Path absolutePathname = Absolute.path((File)pathname);
        Path absoluteConfigurationFile = Absolute.path((File)this.configuration.getConfigurationFile());
        return absolutePathname.equals(absoluteConfigurationFile);
    }

    @ConstructorProperties(value={"configuration", "listener"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigurationFileSystemWatcher(LanguageServerConfiguration configuration, ConfigurationFileChangeListener listener) {
        this.configuration = configuration;
        this.listener = listener;
    }
}

