/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.VariableSymbolComputer$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ModuleSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableKind;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public class VariableSymbolComputer
extends BSLParserBaseVisitor<ParseTree>
implements Computer<List<VariableSymbol>> {
    private final DocumentContext documentContext;
    private final ModuleSymbol module;
    private final Map<Range, SourceDefinedSymbol> methods;
    private final Set<VariableSymbol> variables = new HashSet<VariableSymbol>();
    private final Map<String, String> currentMethodVariables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> moduleVariables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private SourceDefinedSymbol currentMethod;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public VariableSymbolComputer(DocumentContext documentContext, ModuleSymbol module, List<MethodSymbol> methods) {
        this.documentContext = documentContext;
        this.module = module;
        this.methods = methods.stream().collect(Collectors.toMap(MethodSymbol::getSubNameRange, Function.identity()));
        this.currentMethod = module;
    }

    @Override
    public List<VariableSymbol> compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        VariableSymbolComputer$AjcClosure1 variableSymbolComputer$AjcClosure1 = new VariableSymbolComputer$AjcClosure1(objectArray);
        return (List)MeasuresAspect.aspectOf().measureComputers(variableSymbolComputer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public ParseTree visitModuleVarDeclaration(BSLParser.ModuleVarDeclarationContext ctx) {
        if (this.moduleVariables.containsKey(ctx.var_name().getText())) {
            return ctx;
        }
        VariableSymbol symbol = VariableSymbol.builder().name(ctx.var_name().getText()).owner(this.documentContext).range(Ranges.create((ParserRuleContext)ctx)).variableNameRange(Ranges.create((ParserRuleContext)ctx.var_name())).export(ctx.EXPORT_KEYWORD() != null).kind(VariableKind.MODULE).description(this.createDescription((BSLParserRuleContext)ctx)).scope(this.module).build();
        this.variables.add(symbol);
        this.moduleVariables.put(ctx.var_name().getText(), ctx.var_name().getText());
        return ctx;
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.currentMethod = this.getVariableScope(ctx);
        ParseTree tree = (ParseTree)super.visitSub(ctx);
        this.currentMethodVariables.clear();
        this.currentMethod = this.module;
        return tree;
    }

    public ParseTree visitSubVarDeclaration(BSLParser.SubVarDeclarationContext ctx) {
        VariableSymbol symbol = VariableSymbol.builder().name(ctx.var_name().getText()).owner(this.documentContext).range(Ranges.create((ParserRuleContext)ctx)).variableNameRange(Ranges.create((ParserRuleContext)ctx.var_name())).export(false).kind(VariableKind.LOCAL).description(this.createDescription((BSLParserRuleContext)ctx)).scope(this.getVariableScope(ctx)).build();
        this.variables.add(symbol);
        this.currentMethodVariables.put(ctx.var_name().getText(), ctx.var_name().getText());
        return ctx;
    }

    public ParseTree visitParam(BSLParser.ParamContext ctx) {
        if (ctx.IDENTIFIER() == null) {
            return ctx;
        }
        if (this.currentMethod.getSymbolKind() == SymbolKind.Module && this.moduleVariables.containsKey(ctx.IDENTIFIER().getText())) {
            return ctx;
        }
        VariableSymbol variable = VariableSymbol.builder().name(ctx.IDENTIFIER().getText().intern()).scope(this.currentMethod).owner(this.documentContext).range(Ranges.create((ParserRuleContext)ctx)).variableNameRange(Ranges.create(ctx.IDENTIFIER())).export(false).kind(VariableKind.PARAMETER).description(Optional.empty()).build();
        this.variables.add(variable);
        if (this.currentMethod.getSymbolKind() == SymbolKind.Module) {
            this.moduleVariables.put(ctx.IDENTIFIER().getText(), ctx.IDENTIFIER().getText());
        } else {
            this.currentMethodVariables.put(ctx.IDENTIFIER().getText(), ctx.IDENTIFIER().getText());
        }
        return ctx;
    }

    public ParseTree visitLValue(BSLParser.LValueContext ctx) {
        if (ctx.getChildCount() > 1 || this.currentMethodVariables.containsKey(ctx.getText()) || this.moduleVariables.containsKey(ctx.getText())) {
            return ctx;
        }
        this.updateVariablesCache(ctx.IDENTIFIER(), this.createDescription(ctx));
        return ctx;
    }

    public ParseTree visitForStatement(BSLParser.ForStatementContext ctx) {
        if (this.currentMethodVariables.containsKey(ctx.IDENTIFIER().getText()) || this.moduleVariables.containsKey(ctx.IDENTIFIER().getText())) {
            return (ParseTree)super.visitForStatement(ctx);
        }
        this.updateVariablesCache(ctx.IDENTIFIER(), this.createDescription((BSLParserRuleContext)ctx));
        return (ParseTree)super.visitForStatement(ctx);
    }

    public ParseTree visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        if (this.currentMethodVariables.containsKey(ctx.IDENTIFIER().getText()) || this.moduleVariables.containsKey(ctx.IDENTIFIER().getText())) {
            return (ParseTree)super.visitForEachStatement(ctx);
        }
        this.updateVariablesCache(ctx.IDENTIFIER(), this.createDescription((BSLParserRuleContext)ctx));
        return (ParseTree)super.visitForEachStatement(ctx);
    }

    private SourceDefinedSymbol getVariableScope(BSLParser.SubVarDeclarationContext ctx) {
        BSLParser.SubContext sub = (BSLParser.SubContext)Trees.getRootParent((BSLParserRuleContext)ctx, 38);
        if (sub == null) {
            return this.module;
        }
        return this.getVariableScope(sub);
    }

    private SourceDefinedSymbol getVariableScope(BSLParser.SubContext ctx) {
        if (Trees.nodeContainsErrors((ParseTree)ctx)) {
            return this.module;
        }
        BSLParser.SubNameContext subNameNode = ctx.function() != null ? ctx.function().funcDeclaration().subName() : ctx.procedure().procDeclaration().subName();
        return this.methods.getOrDefault(Ranges.create((ParserRuleContext)subNameNode), this.module);
    }

    private Optional<VariableDescription> createDescription(BSLParser.LValueContext ctx) {
        Optional<Token> trailingComments = Trees.getTrailingComment(this.documentContext.getTokens(), ctx.getStop());
        if (trailingComments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new VariableDescription(Collections.emptyList(), trailingComments));
    }

    private Optional<VariableDescription> createDescription(BSLParserRuleContext ctx) {
        List<Token> tokens = this.documentContext.getTokens();
        ArrayList<Token> comments = new ArrayList<Token>();
        Optional<Token> varToken = Trees.getPreviousTokenFromDefaultChannel(tokens, ctx.getStart().getTokenIndex(), 65);
        varToken.ifPresent(value -> comments.addAll(Trees.getComments(tokens, value)));
        Optional<Token> trailingComments = Trees.getTrailingComment(tokens, ctx.getStop());
        if (comments.isEmpty() && trailingComments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new VariableDescription(comments, trailingComments));
    }

    private void updateVariablesCache(TerminalNode node, Optional<VariableDescription> description) {
        VariableSymbol variable = VariableSymbol.builder().name(node.getText().intern()).owner(this.documentContext).range(Ranges.create(node)).variableNameRange(Ranges.create(node)).export(false).kind(VariableKind.DYNAMIC).scope(this.currentMethod).description(description).build();
        this.variables.add(variable);
        if (this.currentMethod == this.module) {
            this.moduleVariables.put(node.getText(), node.getText());
        } else {
            this.currentMethodVariables.put(node.getText(), node.getText());
        }
    }

    static {
        VariableSymbolComputer.ajc$preClinit();
    }

    static final /* synthetic */ List compute_aroundBody0(VariableSymbolComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.variables.clear();
        ajc$this.moduleVariables.clear();
        ajc$this.visitFile(ajc$this.documentContext.getAst());
        return new ArrayList<VariableSymbol>(ajc$this.variables);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VariableSymbolComputer.java", VariableSymbolComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.VariableSymbolComputer", "", "", "", "java.util.List"), 74);
    }
}

