/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class ParameterDefinition {
    private final String name;
    private final boolean byValue;
    private final Optional<ParameterDescription> description;
    private final DefaultValue defaultValue;
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;

    public Range getRange() {
        return Ranges.create(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
    }

    public boolean isOptional() {
        return !DefaultValue.EMPTY.equals(this.defaultValue);
    }

    public static ParameterDefinitionBuilder builder() {
        return new ParameterDefinitionBuilder();
    }

    @ConstructorProperties(value={"name", "byValue", "description", "defaultValue", "startLine", "startCharacter", "endLine", "endCharacter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ParameterDefinition(String name, boolean byValue, Optional<ParameterDescription> description, DefaultValue defaultValue, int startLine, int startCharacter, int endLine, int endCharacter) {
        this.name = name;
        this.byValue = byValue;
        this.description = description;
        this.defaultValue = defaultValue;
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isByValue() {
        return this.byValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<ParameterDescription> getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)o;
        if (this.isByValue() != other.isByValue()) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        if (this.startCharacter != other.startCharacter) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endCharacter != other.endCharacter) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<ParameterDescription> this$description = this.getDescription();
        Optional<ParameterDescription> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        DefaultValue this$defaultValue = this.getDefaultValue();
        DefaultValue other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isByValue() ? 79 : 97);
        result = result * 59 + this.startLine;
        result = result * 59 + this.startCharacter;
        result = result * 59 + this.endLine;
        result = result * 59 + this.endCharacter;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<ParameterDescription> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        DefaultValue $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ParameterDefinition(name=" + this.getName() + ", byValue=" + this.isByValue() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")";
    }

    public static final class DefaultValue {
        public static final DefaultValue EMPTY = new DefaultValue(ParameterType.EMPTY, "");
        private final ParameterType type;
        private final String value;

        @ConstructorProperties(value={"type", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DefaultValue(ParameterType type, String value) {
            this.type = type;
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultValue)) {
                return false;
            }
            DefaultValue other = (DefaultValue)o;
            ParameterType this$type = this.getType();
            ParameterType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ParameterType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ParameterDefinition.DefaultValue(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }

    public static class ParameterDefinitionBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean byValue;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<ParameterDescription> description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DefaultValue defaultValue;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endCharacter;

        public ParameterDefinitionBuilder range(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.startLine = start.getLine();
            this.startCharacter = start.getCharacter();
            this.endLine = end.getLine();
            this.endCharacter = end.getCharacter();
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ParameterDefinitionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder byValue(boolean byValue) {
            this.byValue = byValue;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder description(Optional<ParameterDescription> description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder startCharacter(int startCharacter) {
            this.startCharacter = startCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder endCharacter(int endCharacter) {
            this.endCharacter = endCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinition build() {
            return new ParameterDefinition(this.name, this.byValue, this.description, this.defaultValue, this.startLine, this.startCharacter, this.endLine, this.endCharacter);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ParameterDefinition.ParameterDefinitionBuilder(name=" + this.name + ", byValue=" + this.byValue + ", description=" + this.description + ", defaultValue=" + this.defaultValue + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")";
        }
    }

    public static enum ParameterType {
        DATETIME,
        BOOLEAN,
        UNDEFINED,
        NULL,
        STRING,
        NUMERIC,
        EMPTY;

    }
}

