/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ModuleSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Range;

public final class SymbolTree {
    private final ModuleSymbol module;
    private final AtomicReference<Object> childrenFlat = new AtomicReference();
    private final AtomicReference<Object> methods = new AtomicReference();
    private final AtomicReference<Object> methodsByName = new AtomicReference();
    private final AtomicReference<Object> variables = new AtomicReference();
    private final AtomicReference<Object> variablesByName = new AtomicReference();

    public List<SourceDefinedSymbol> getChildren() {
        return this.module.getChildren();
    }

    public <T> List<T> getChildrenFlat(Class<T> clazz) {
        return this.getChildrenFlat().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public List<RegionSymbol> getModuleLevelRegions() {
        return this.getChildren().stream().filter(RegionSymbol.class::isInstance).map(RegionSymbol.class::cast).collect(Collectors.toList());
    }

    public List<RegionSymbol> getRegionsFlat() {
        return this.getChildrenFlat(RegionSymbol.class);
    }

    public Optional<MethodSymbol> getMethodSymbol(BSLParserRuleContext ctx) {
        Object subNameNode = Trees.nodeContainsErrors((ParseTree)ctx) ? ctx : (ctx instanceof BSLParser.SubContext ? (((BSLParser.SubContext)ctx).function() == null ? ((BSLParser.SubContext)ctx).procedure().procDeclaration().subName() : ((BSLParser.SubContext)ctx).function().funcDeclaration().subName()) : ctx);
        Range subNameRange = Ranges.create((ParserRuleContext)subNameNode);
        return this.getMethods().stream().filter(methodSymbol -> methodSymbol.getSubNameRange().equals((Object)subNameRange)).findAny();
    }

    public Optional<MethodSymbol> getMethodSymbol(String methodName) {
        return Optional.ofNullable(this.getMethodsByName().get(methodName));
    }

    public Optional<VariableSymbol> getVariableSymbol(BSLParserRuleContext ctx) {
        Object varNameNode = Trees.nodeContainsErrors((ParseTree)ctx) ? ctx : (ctx instanceof BSLParser.ModuleVarDeclarationContext ? ((BSLParser.ModuleVarDeclarationContext)ctx).var_name() : (ctx instanceof BSLParser.SubVarDeclarationContext ? ((BSLParser.SubVarDeclarationContext)ctx).var_name() : ctx));
        Range variableNameRange = Ranges.create((ParserRuleContext)varNameNode);
        return this.getVariables().stream().filter(variableSymbol -> variableSymbol.getVariableNameRange().equals((Object)variableNameRange)).findAny();
    }

    public Optional<VariableSymbol> getVariableSymbol(String variableName, SourceDefinedSymbol scopeSymbol) {
        return Optional.ofNullable((VariableSymbol)this.getVariablesByName().getOrDefault(scopeSymbol, Collections.emptyMap()).get(variableName));
    }

    private List<SourceDefinedSymbol> createChildrenFlat() {
        ArrayList<SourceDefinedSymbol> symbols = new ArrayList<SourceDefinedSymbol>();
        this.getChildren().forEach(child -> SymbolTree.flatten(child, symbols));
        return symbols;
    }

    private List<MethodSymbol> createMethods() {
        return this.getChildrenFlat(MethodSymbol.class);
    }

    private List<VariableSymbol> createVariables() {
        return this.getChildrenFlat(VariableSymbol.class);
    }

    private Map<SourceDefinedSymbol, Map<String, VariableSymbol>> createVariablesByName() {
        return this.getVariables().stream().collect(Collectors.groupingBy(VariableSymbol::getScope, Collectors.toMap(Symbol::getName, Function.identity(), (existing, replacement) -> existing, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER))));
    }

    private Map<String, MethodSymbol> createMethodsByName() {
        return this.getMethods().stream().collect(Collectors.toMap(MethodSymbol::getName, Function.identity(), (existing, replacement) -> existing, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    }

    private static void flatten(SourceDefinedSymbol symbol, List<SourceDefinedSymbol> symbols) {
        symbols.add(symbol);
        symbol.getChildren().forEach(child -> SymbolTree.flatten(child, symbols));
    }

    @ConstructorProperties(value={"module"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SymbolTree(ModuleSymbol module) {
        this.module = module;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ModuleSymbol getModule() {
        return this.module;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymbolTree)) {
            return false;
        }
        SymbolTree other = (SymbolTree)o;
        ModuleSymbol this$module = this.getModule();
        ModuleSymbol other$module = other.getModule();
        if (this$module == null ? other$module != null : !((Object)this$module).equals(other$module)) {
            return false;
        }
        List<SourceDefinedSymbol> this$childrenFlat = this.getChildrenFlat();
        List<SourceDefinedSymbol> other$childrenFlat = other.getChildrenFlat();
        if (this$childrenFlat == null ? other$childrenFlat != null : !((Object)this$childrenFlat).equals(other$childrenFlat)) {
            return false;
        }
        List<MethodSymbol> this$methods = this.getMethods();
        List<MethodSymbol> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Map<String, MethodSymbol> this$methodsByName = this.getMethodsByName();
        Map<String, MethodSymbol> other$methodsByName = other.getMethodsByName();
        if (this$methodsByName == null ? other$methodsByName != null : !((Object)this$methodsByName).equals(other$methodsByName)) {
            return false;
        }
        List<VariableSymbol> this$variables = this.getVariables();
        List<VariableSymbol> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        Map<SourceDefinedSymbol, Map<String, VariableSymbol>> this$variablesByName = this.getVariablesByName();
        Map<SourceDefinedSymbol, Map<String, VariableSymbol>> other$variablesByName = other.getVariablesByName();
        return !(this$variablesByName == null ? other$variablesByName != null : !((Object)this$variablesByName).equals(other$variablesByName));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModuleSymbol $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : ((Object)$module).hashCode());
        List<SourceDefinedSymbol> $childrenFlat = this.getChildrenFlat();
        result = result * 59 + ($childrenFlat == null ? 43 : ((Object)$childrenFlat).hashCode());
        List<MethodSymbol> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Map<String, MethodSymbol> $methodsByName = this.getMethodsByName();
        result = result * 59 + ($methodsByName == null ? 43 : ((Object)$methodsByName).hashCode());
        List<VariableSymbol> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        Map<SourceDefinedSymbol, Map<String, VariableSymbol>> $variablesByName = this.getVariablesByName();
        result = result * 59 + ($variablesByName == null ? 43 : ((Object)$variablesByName).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SymbolTree(module=" + this.getModule() + ", childrenFlat=" + this.getChildrenFlat() + ", methods=" + this.getMethods() + ", methodsByName=" + this.getMethodsByName() + ", variables=" + this.getVariables() + ", variablesByName=" + this.getVariablesByName() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SourceDefinedSymbol> getChildrenFlat() {
        Object value = this.childrenFlat.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.childrenFlat;
            synchronized (atomicReference) {
                value = this.childrenFlat.get();
                if (value == null) {
                    List<SourceDefinedSymbol> actualValue = this.createChildrenFlat();
                    value = actualValue == null ? this.childrenFlat : actualValue;
                    this.childrenFlat.set(value);
                }
            }
        }
        return (List)(value == this.childrenFlat ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MethodSymbol> getMethods() {
        Object value = this.methods.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.methods;
            synchronized (atomicReference) {
                value = this.methods.get();
                if (value == null) {
                    List<MethodSymbol> actualValue = this.createMethods();
                    value = actualValue == null ? this.methods : actualValue;
                    this.methods.set(value);
                }
            }
        }
        return (List)(value == this.methods ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, MethodSymbol> getMethodsByName() {
        Object value = this.methodsByName.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.methodsByName;
            synchronized (atomicReference) {
                value = this.methodsByName.get();
                if (value == null) {
                    Map<String, MethodSymbol> actualValue = this.createMethodsByName();
                    value = actualValue == null ? this.methodsByName : actualValue;
                    this.methodsByName.set(value);
                }
            }
        }
        return (Map)(value == this.methodsByName ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<VariableSymbol> getVariables() {
        Object value = this.variables.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.variables;
            synchronized (atomicReference) {
                value = this.variables.get();
                if (value == null) {
                    List<VariableSymbol> actualValue = this.createVariables();
                    value = actualValue == null ? this.variables : actualValue;
                    this.variables.set(value);
                }
            }
        }
        return (List)(value == this.variables ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<SourceDefinedSymbol, Map<String, VariableSymbol>> getVariablesByName() {
        Object value = this.variablesByName.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.variablesByName;
            synchronized (atomicReference) {
                value = this.variablesByName.get();
                if (value == null) {
                    Map<SourceDefinedSymbol, Map<String, VariableSymbol>> actualValue = this.createVariablesByName();
                    value = actualValue == null ? this.variablesByName : actualValue;
                    this.variablesByName.set(value);
                }
            }
        }
        return (Map)(value == this.variablesByName ? null : value);
    }
}

