/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.databind;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.commands.CommandArguments;
import com.github._1c_syntax.bsl.languageserver.commands.CommandSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ObjectMapperConfiguration {
    @Bean
    public ObjectMapper objectMapper(Collection<CodeLensSupplier<? extends CodeLensData>> codeLensResolvers, Collection<CommandSupplier<? extends CommandArguments>> commandSuppliers) {
        ArrayList<NamedType> namedTypes = new ArrayList<NamedType>();
        codeLensResolvers.stream().map(ObjectMapperConfiguration::toNamedType).collect(Collectors.toCollection(() -> namedTypes));
        commandSuppliers.stream().map(ObjectMapperConfiguration::toNamedType).collect(Collectors.toCollection(() -> namedTypes));
        JsonMapper.Builder objectMapperBuilder = JsonMapper.builder();
        namedTypes.forEach(xva$0 -> {
            JsonMapper.Builder cfr_ignored_0 = (JsonMapper.Builder)objectMapperBuilder.registerSubtypes(new NamedType[]{xva$0});
        });
        return objectMapperBuilder.build();
    }

    private static NamedType toNamedType(CodeLensSupplier<? extends CodeLensData> codeLensSupplier) {
        return new NamedType(codeLensSupplier.getCodeLensDataClass(), codeLensSupplier.getId());
    }

    private static NamedType toNamedType(CommandSupplier<? extends CommandArguments> commandSupplier) {
        return new NamedType(commandSupplier.getCommandArgumentsClass(), commandSupplier.getId());
    }
}

