/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Range;

abstract class AbstractCommonModuleNameDiagnostic
extends AbstractDiagnostic {
    protected Pattern pattern;
    private final LanguageServerConfiguration serverConfiguration;

    protected AbstractCommonModuleNameDiagnostic(LanguageServerConfiguration serverConfiguration, String regexp) {
        this.serverConfiguration = serverConfiguration;
        this.pattern = CaseInsensitivePattern.compile((String)regexp);
    }

    @Override
    protected void check() {
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty(range)) {
            return;
        }
        this.documentContext.getMdObject().filter(MDCommonModule.class::isInstance).map(MDCommonModule.class::cast).filter(this::flagsCheck).map(AbstractMDObjectBase::getName).map(this.pattern::matcher).filter(this::matchCheck).ifPresent(commonModule -> this.diagnosticStorage.addDiagnostic(range));
    }

    protected abstract boolean flagsCheck(MDCommonModule var1);

    protected boolean matchCheck(Matcher matcher) {
        return !matcher.find();
    }

    protected boolean isClientServer(MDCommonModule commonModule) {
        return !commonModule.isServerCall() && commonModule.isServer() && commonModule.isExternalConnection() && this.isClientApplication(commonModule);
    }

    protected boolean isClient(MDCommonModule commonModule) {
        return !commonModule.isServerCall() && !commonModule.isServer() && !commonModule.isExternalConnection() && this.isClientApplication(commonModule);
    }

    protected boolean isServerCall(MDCommonModule commonModule) {
        return commonModule.isServerCall() && commonModule.isServer() && !commonModule.isExternalConnection() && !commonModule.isClientOrdinaryApplication() && !commonModule.isClientManagedApplication();
    }

    protected boolean isServer(MDCommonModule commonModule) {
        return !commonModule.isServerCall() && commonModule.isServer() && commonModule.isExternalConnection() && this.isClientOrdinaryAppIfNeed(commonModule) && !commonModule.isClientManagedApplication();
    }

    private boolean isClientApplication(MDCommonModule commonModule) {
        return this.isClientOrdinaryAppIfNeed(commonModule) && commonModule.isClientManagedApplication();
    }

    private boolean isClientOrdinaryAppIfNeed(MDCommonModule commonModule) {
        return commonModule.isClientOrdinaryApplication() || !this.serverConfiguration.getDiagnosticsOptions().isOrdinaryAppSupport();
    }
}

