/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.support.ReturnValueReuse;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, modules={ModuleType.CommonModule}, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.DESIGN})
public class CachedPublicDiagnostic
extends AbstractDiagnostic {
    private static final Pattern PUBLIC = CaseInsensitivePattern.compile((String)String.format("^(%s|%s)$", "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", "Public"));

    @Override
    protected void check() {
        if (!this.isCashed(this.documentContext)) {
            return;
        }
        this.documentContext.getSymbolTree().getModuleLevelRegions().stream().filter(regionSymbol -> !regionSymbol.getMethods().isEmpty()).filter(regionSymbol -> PUBLIC.matcher(regionSymbol.getName()).find()).forEach(regionSymbol -> this.diagnosticStorage.addDiagnostic(regionSymbol.getRegionNameRange()));
    }

    private boolean isCashed(DocumentContext documentContext) {
        return documentContext.getMdObject().filter(MDCommonModule.class::isInstance).map(MDCommonModule.class::cast).map(MDCommonModule::getReturnValuesReuse).filter(this::isReuseValue).isPresent();
    }

    private Boolean isReuseValue(ReturnValueReuse value) {
        return value == ReturnValueReuse.DURING_REQUEST || value == ReturnValueReuse.DURING_SESSION;
    }
}

