/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexitySecondaryLocation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.CRITICAL, minutesToFix=15, tags={DiagnosticTag.BRAINOVERLOAD})
public class CognitiveComplexityDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int COMPLEXITY_THRESHOLD = 15;
    private static final boolean CHECK_MODULE_BODY = true;
    @DiagnosticParameter(type=Integer.class, defaultValue="15")
    private int complexityThreshold = 15;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkModuleBody = true;
    private boolean fileCodeBlockChecked;

    private List<DiagnosticRelatedInformation> makeRelations(MethodSymbol methodSymbol, Integer methodComplexity) {
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), methodSymbol.getSubNameRange(), this.info.getMessage(methodSymbol.getName(), methodComplexity, this.complexityThreshold)));
        List<ComplexitySecondaryLocation> secondaryLocations = this.documentContext.getCognitiveComplexityData().getMethodsComplexitySecondaryLocations().get(methodSymbol);
        secondaryLocations.stream().map(secondaryLocation -> RelatedInformation.create(this.documentContext.getUri(), secondaryLocation.getRange(), secondaryLocation.getMessage())).collect(Collectors.toCollection(() -> relatedInformation));
        return relatedInformation;
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        Optional<MethodSymbol> optionalMethodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        optionalMethodSymbol.ifPresent(methodSymbol -> {
            Integer methodComplexity = this.documentContext.getCognitiveComplexityData().getMethodsComplexity().get(methodSymbol);
            if (methodComplexity > this.complexityThreshold) {
                ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
                relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), methodSymbol.getSubNameRange(), this.info.getMessage(methodSymbol.getName(), methodComplexity, this.complexityThreshold)));
                List<ComplexitySecondaryLocation> secondaryLocations = this.documentContext.getCognitiveComplexityData().getMethodsComplexitySecondaryLocations().get(methodSymbol);
                secondaryLocations.stream().map(secondaryLocation -> RelatedInformation.create(this.documentContext.getUri(), secondaryLocation.getRange(), secondaryLocation.getMessage())).collect(Collectors.toCollection(() -> relatedInformation));
                this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getMessage(methodSymbol.getName(), methodComplexity, this.complexityThreshold), this.makeRelations((MethodSymbol)methodSymbol, methodComplexity));
            }
        });
        return ctx;
    }

    public ParseTree visitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.checkFileCodeBlock((BSLParserRuleContext)ctx);
        this.fileCodeBlockChecked = ctx.getChildCount() > 0;
        return ctx;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        if (!this.fileCodeBlockChecked) {
            this.checkFileCodeBlock((BSLParserRuleContext)ctx);
        }
        return ctx;
    }

    private void checkFileCodeBlock(BSLParserRuleContext ctx) {
        if (!this.checkModuleBody) {
            return;
        }
        Integer fileCodeBlockComplexity = this.documentContext.getCognitiveComplexityData().getFileCodeBlockComplexity();
        if (fileCodeBlockComplexity > this.complexityThreshold) {
            ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
            relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create(ctx.getStart()), this.info.getMessage("body", fileCodeBlockComplexity, this.complexityThreshold)));
            List<ComplexitySecondaryLocation> secondaryLocations = this.documentContext.getCognitiveComplexityData().getFileBlockComplexitySecondaryLocations();
            secondaryLocations.stream().map(secondaryLocation -> RelatedInformation.create(this.documentContext.getUri(), secondaryLocation.getRange(), secondaryLocation.getMessage())).collect(Collectors.toCollection(() -> relatedInformation));
            this.diagnosticStorage.addDiagnostic(ctx.getStart(), this.info.getMessage("body", fileCodeBlockComplexity, this.complexityThreshold), relatedInformation);
        }
    }
}

