/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.recognizer.BSLFootprint;
import com.github._1c_syntax.bsl.languageserver.recognizer.CodeRecognizer;
import com.github._1c_syntax.bsl.parser.BSLTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class CommentedCodeDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    private static final float COMMENTED_CODE_THRESHOLD = 0.9f;
    private static final String COMMENT_START = "//";
    private static final int MINIMAL_TOKEN_COUNT = 2;
    @DiagnosticParameter(type=Float.class, defaultValue="0.9")
    private float threshold = 0.9f;
    @DiagnosticParameter(type=String.class)
    private Set<String> exclusionPrefixes = Collections.emptySet();
    private List<MethodDescription> methodDescriptions;
    private CodeRecognizer codeRecognizer = new CodeRecognizer(this.threshold, new BSLFootprint());

    @Override
    public void configure(Map<String, Object> configuration) {
        this.threshold = ((Number)configuration.getOrDefault("threshold", Float.valueOf(this.threshold))).floatValue();
        this.codeRecognizer = new CodeRecognizer(this.threshold, new BSLFootprint());
        String excludePrefixesString = (String)configuration.getOrDefault("exclusionPrefixes", "");
        this.exclusionPrefixes = Arrays.stream(excludePrefixesString.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    @Override
    public void check() {
        this.methodDescriptions = this.documentContext.getSymbolTree().getMethods().stream().map(MethodSymbol::getDescription).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.groupComments(this.documentContext.getComments()).stream().filter(this::isCommentGroupNotMethodDescription).forEach(this::checkCommentGroup);
    }

    private List<List<Token>> groupComments(List<Token> comments) {
        ArrayList<List<Token>> groups = new ArrayList<List<Token>>();
        List<Token> currentGroup = null;
        for (Token comment : comments) {
            if (currentGroup == null) {
                currentGroup = CommentedCodeDiagnostic.initNewGroup(comment);
                continue;
            }
            if (this.isAdjacent(comment, currentGroup)) {
                currentGroup.add(comment);
                continue;
            }
            groups.add(currentGroup);
            currentGroup = CommentedCodeDiagnostic.initNewGroup(comment);
        }
        if (currentGroup != null) {
            groups.add(currentGroup);
        }
        return groups;
    }

    private static List<Token> initNewGroup(Token comment) {
        ArrayList<Token> group = new ArrayList<Token>();
        group.add(comment);
        return group;
    }

    private boolean isAdjacent(Token comment, List<Token> currentGroup) {
        Token last = currentGroup.get(currentGroup.size() - 1);
        return last.getLine() + 1 == comment.getLine() && this.onlyEmptyDelimiters(last.getTokenIndex(), comment.getTokenIndex());
    }

    private boolean onlyEmptyDelimiters(int firstTokenIndex, int lastTokenIndex) {
        if (firstTokenIndex > lastTokenIndex) {
            return false;
        }
        for (int index = firstTokenIndex + 1; index < lastTokenIndex; ++index) {
            int tokenType = this.documentContext.getTokens().get(index).getType();
            if (tokenType == 2) continue;
            return false;
        }
        return true;
    }

    private boolean isCommentGroupNotMethodDescription(List<Token> commentGroup) {
        if (this.methodDescriptions.isEmpty()) {
            return true;
        }
        Token first = commentGroup.get(0);
        Token last = commentGroup.get(commentGroup.size() - 1);
        return this.methodDescriptions.stream().noneMatch(methodDescription -> methodDescription.contains(first, last));
    }

    private void checkCommentGroup(List<Token> commentGroup) {
        Token firstComment = commentGroup.get(0);
        Token lastComment = commentGroup.get(commentGroup.size() - 1);
        for (Token comment : commentGroup) {
            if (!this.isTextParsedAsCode(comment.getText())) continue;
            this.diagnosticStorage.addDiagnostic(firstComment, lastComment);
            return;
        }
    }

    private boolean isTextParsedAsCode(String text) {
        String uncommented = CommentedCodeDiagnostic.uncomment(text);
        for (String prefix : this.exclusionPrefixes) {
            if (!uncommented.startsWith(prefix)) continue;
            return false;
        }
        if (!this.codeRecognizer.meetsCondition(text)) {
            return false;
        }
        BSLTokenizer tokenizer = new BSLTokenizer(uncommented);
        List tokens = tokenizer.getTokens();
        if (tokens.size() >= 2) {
            List tokenTypes = tokens.stream().map(Token::getType).filter(t -> t != 2).collect(Collectors.toList());
            for (int i = 0; i < tokenTypes.size() - 1; ++i) {
                if ((Integer)tokenTypes.get(i) != 76 || (Integer)tokenTypes.get(i + 1) != 76) continue;
                return false;
            }
        }
        return true;
    }

    private static String uncomment(String comment) {
        if (comment.startsWith(COMMENT_START)) {
            return CommentedCodeDiagnostic.uncomment(comment.substring(COMMENT_START.length()));
        }
        return comment;
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        List<TextEdit> textEdits = diagnostics.stream().map(Diagnostic::getRange).map(range -> new TextEdit(range, "")).collect(Collectors.toList());
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }
}

