/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectComplex;
import com.github._1c_syntax.mdclasses.mdo.attributes.Dimension;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@DiagnosticMetadata(activatedByDefault=false, type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE}, scope=DiagnosticScope.BSL)
public class DenyIncompleteValuesDiagnostic
extends AbstractMetadataDiagnostic {
    public DenyIncompleteValuesDiagnostic() {
        super(List.of(MDOType.INFORMATION_REGISTER, MDOType.ACCUMULATION_REGISTER, MDOType.ACCOUNTING_REGISTER, MDOType.CALCULATION_REGISTER));
    }

    @Override
    protected void checkMetadata(AbstractMDObjectBase mdo) {
        DenyIncompleteValuesDiagnostic.getWrongDimensions((AbstractMDObjectComplex)mdo).forEach(dimension -> {
            String ownerMDOName = MdoRefBuilder.getLocaleOwnerMdoName(this.documentContext, (MD)mdo);
            this.addDiagnostic(this.info.getMessage(dimension.getName(), ownerMDOName));
        });
    }

    @NotNull
    private static Stream<Dimension> getWrongDimensions(AbstractMDObjectComplex mdo) {
        return mdo.getChildren().stream().filter(Dimension.class::isInstance).map(Dimension.class::cast).filter(dimension -> !dimension.isDenyIncompleteValues());
    }
}

