/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticCodeDescription;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DiagnosticStorage {
    private final BSLDiagnostic diagnostic;
    private final Queue<Diagnostic> diagnosticList = new ConcurrentLinkedQueue<Diagnostic>();

    DiagnosticStorage(BSLDiagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    public List<Diagnostic> getDiagnostics() {
        return new ArrayList<Diagnostic>(this.diagnosticList);
    }

    public void clearDiagnostics() {
        this.diagnosticList.clear();
    }

    protected void addDiagnostic(BSLParserRuleContext node) {
        if (node.exception != null) {
            return;
        }
        this.addDiagnostic(Ranges.create((ParserRuleContext)node));
    }

    protected void addDiagnostic(BSLParserRuleContext node, String diagnosticMessage) {
        if (node.exception != null) {
            return;
        }
        this.addDiagnostic(Ranges.create((ParserRuleContext)node), diagnosticMessage);
    }

    protected void addDiagnostic(int startLine, int startChar, int endLine, int endChar) {
        this.addDiagnostic(Ranges.create(startLine, startChar, endLine, endChar));
    }

    protected void addDiagnostic(Range range) {
        this.addDiagnostic(range, this.diagnostic.getInfo().getMessage());
    }

    protected void addDiagnostic(Range range, String diagnosticMessage) {
        this.addDiagnostic(range, diagnosticMessage, null);
    }

    protected void addDiagnostic(Token token) {
        this.addDiagnostic(Ranges.create(token));
    }

    protected void addDiagnostic(Token startToken, Token endToken) {
        this.addDiagnostic(Ranges.create(startToken, endToken));
    }

    protected void addDiagnostic(Token token, String diagnosticMessage) {
        this.addDiagnostic(Ranges.create(token), diagnosticMessage);
    }

    protected void addDiagnostic(TerminalNode terminalNode) {
        this.addDiagnostic(terminalNode.getSymbol());
    }

    protected void addDiagnostic(TerminalNode terminalNode, String diagnosticMessage) {
        this.addDiagnostic(terminalNode.getSymbol(), diagnosticMessage);
    }

    protected void addDiagnostic(TerminalNode startTerminalNode, TerminalNode stopTerminalNode) {
        this.addDiagnostic(startTerminalNode.getSymbol(), stopTerminalNode.getSymbol());
    }

    protected void addDiagnostic(BSLParserRuleContext node, List<DiagnosticRelatedInformation> relatedInformation) {
        if (node.exception != null) {
            return;
        }
        this.addDiagnostic(node, this.diagnostic.getInfo().getMessage(), relatedInformation);
    }

    public void addDiagnostic(Token token, List<DiagnosticRelatedInformation> relatedInformation) {
        this.addDiagnostic(token, this.diagnostic.getInfo().getMessage(), relatedInformation);
    }

    public void addDiagnostic(BSLParserRuleContext node, String diagnosticMessage, List<DiagnosticRelatedInformation> relatedInformation) {
        if (node.exception != null) {
            return;
        }
        this.addDiagnostic(Ranges.create((ParserRuleContext)node), diagnosticMessage, relatedInformation);
    }

    public void addDiagnostic(Token token, String diagnosticMessage, List<DiagnosticRelatedInformation> relatedInformation) {
        this.addDiagnostic(Ranges.create(token), diagnosticMessage, relatedInformation);
    }

    public void addDiagnostic(Range range, List<DiagnosticRelatedInformation> relatedInformation) {
        this.addDiagnostic(range, this.diagnostic.getInfo().getMessage(), relatedInformation);
    }

    public void addDiagnostic(Range range, String diagnosticMessage, @Nullable List<DiagnosticRelatedInformation> relatedInformation) {
        if (Ranges.isEmpty(range)) {
            return;
        }
        this.diagnosticList.add(DiagnosticStorage.createDiagnostic(this.diagnostic, range, diagnosticMessage, relatedInformation));
    }

    public void addDiagnostic(ParseTree tree) {
        if (tree instanceof BSLParserRuleContext) {
            this.addDiagnostic((BSLParserRuleContext)tree);
        } else if (tree instanceof TerminalNode) {
            this.addDiagnostic((TerminalNode)tree);
        } else {
            throw new IllegalArgumentException("Unsupported parameter type " + tree);
        }
    }

    protected void addDiagnostic(SourceDefinedSymbol sourceDefinedSymbol) {
        this.addDiagnostic(sourceDefinedSymbol.getSelectionRange());
    }

    private static Diagnostic createDiagnostic(BSLDiagnostic bslDiagnostic, Range range, String diagnosticMessage, @Nullable List<DiagnosticRelatedInformation> relatedInformation) {
        DiagnosticInfo info = bslDiagnostic.getInfo();
        Diagnostic diagnostic = new Diagnostic(range, diagnosticMessage, info.getLSPSeverity(), "bsl-language-server");
        diagnostic.setCode((Either)info.getCode());
        diagnostic.setTags(info.getLSPTags());
        DiagnosticCodeDescription codeDescription = new DiagnosticCodeDescription(info.getDiagnosticCodeDescriptionHref());
        diagnostic.setCodeDescription(codeDescription);
        if (relatedInformation != null) {
            diagnostic.setRelatedInformation(relatedInformation);
        }
        return diagnostic;
    }
}

