/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSDBLVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=2, activatedByDefault=false, tags={DiagnosticTag.SQL, DiagnosticTag.SUSPICIOUS, DiagnosticTag.UNPREDICTABLE})
public class FieldsFromJoinsWithoutIsNullDiagnostic
extends AbstractSDBLVisitorDiagnostic {
    private static final Integer EXCLUDED_TOP_RULE_FOR_SELECT = 10;
    private static final Collection<Integer> SELECT_STATEMENTS = Set.of(EXCLUDED_TOP_RULE_FOR_SELECT, Integer.valueOf(33), Integer.valueOf(40));
    private static final Integer EXCLUDED_TOP_RULE_FOR_WHERE = 6;
    private static final Collection<Integer> WHERE_STATEMENTS = Set.of(EXCLUDED_TOP_RULE_FOR_WHERE, Integer.valueOf(33), Integer.valueOf(40));
    private static final Integer EXCLUDED_TOP_RULE_FOR_JOIN = 52;
    private static final Collection<Integer> JOIN_STATEMENTS = Set.of(EXCLUDED_TOP_RULE_FOR_JOIN, Integer.valueOf(33));
    public static final Collection<Integer> RULES_OF_PARENT_FOR_SEARCH_CONDITION = Set.of(Integer.valueOf(38), Integer.valueOf(6));
    public static final int NOT_WITH_PARENS_EXPR_MEMBERS_COUNT = 4;
    public static final int NOT_IS_NULL_EXPR_MEMBER_COUNT = 2;
    private final List<BSLParserRuleContext> nodesForIssues = new ArrayList<BSLParserRuleContext>();

    public ParseTree visitJoinPart(SDBLParser.JoinPartContext joinPartCtx) {
        FieldsFromJoinsWithoutIsNullDiagnostic.joinedTables(joinPartCtx).forEach(tableName -> this.checkQuery((String)tableName, joinPartCtx));
        if (!this.nodesForIssues.isEmpty()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)joinPartCtx, this.getRelatedInformation(joinPartCtx));
            this.nodesForIssues.clear();
        }
        return (ParseTree)super.visitJoinPart(joinPartCtx);
    }

    private static Stream<String> joinedTables(SDBLParser.JoinPartContext joinPartCtx) {
        return Optional.of(joinPartCtx).stream().flatMap(joinPartContext -> FieldsFromJoinsWithoutIsNullDiagnostic.joinedDataSourceContext(joinPartContext).stream()).filter(Objects::nonNull).map(SDBLParser.DataSourceContext::alias).filter(Objects::nonNull).map(SDBLParser.AliasContext::identifier).map(BSLParserRuleContext::getText);
    }

    private static List<SDBLParser.DataSourceContext> joinedDataSourceContext(SDBLParser.JoinPartContext joinPartCtx) {
        List<Object> result = joinPartCtx.LEFT() != null ? Collections.singletonList(joinPartCtx.dataSource()) : (joinPartCtx.RIGHT() != null ? Collections.singletonList((SDBLParser.DataSourceContext)joinPartCtx.getParent()) : (joinPartCtx.FULL() != null ? Arrays.asList((SDBLParser.DataSourceContext)joinPartCtx.getParent(), joinPartCtx.dataSource()) : Collections.emptyList()));
        return result;
    }

    private void checkQuery(String joinedTableName, SDBLParser.JoinPartContext joinPartCtx) {
        Optional.ofNullable(Trees.getRootParent((BSLParserRuleContext)joinPartCtx, 6)).map(SDBLParser.QueryContext.class::cast).filter(ctx -> !FieldsFromJoinsWithoutIsNullDiagnostic.haveExprNotIsNullInsideWhere(ctx.where)).ifPresent(queryCtx -> {
            this.checkSelect(joinedTableName, queryCtx.columns);
            this.checkWhere(joinedTableName, queryCtx.where);
            this.checkAllJoins(joinedTableName, joinPartCtx);
        });
    }

    private static boolean haveExprNotIsNullInsideWhere(@Nullable SDBLParser.LogicalExpressionContext whereCtx) {
        return Optional.ofNullable(whereCtx).stream().flatMap(ctx -> Trees.findAllRuleNodes((ParseTree)ctx, 40).stream()).map(SDBLParser.IsNullPredicateContext.class::cast).anyMatch(isNullPredicateCtx -> FieldsFromJoinsWithoutIsNullDiagnostic.haveFirstIsThenNotThenNull(isNullPredicateCtx) || FieldsFromJoinsWithoutIsNullDiagnostic.haveExprNotIsNullInsideWhere(isNullPredicateCtx));
    }

    private static boolean haveFirstIsThenNotThenNull(SDBLParser.IsNullPredicateContext isNullPredicateContext) {
        return isNullPredicateContext.NOT() != null;
    }

    private static boolean haveExprNotIsNullInsideWhere(SDBLParser.IsNullPredicateContext isNullPredicateCtx) {
        SDBLParser.PredicateContext parent = (SDBLParser.PredicateContext)isNullPredicateCtx.getParent();
        if (parent.getChildCount() == 2 && parent.NOT() != null) {
            return true;
        }
        return FieldsFromJoinsWithoutIsNullDiagnostic.haveExprNotWithParens(parent);
    }

    private static boolean isTerminalNodeNOT(ParseTree node) {
        return node instanceof TerminalNode && ((TerminalNode)node).getSymbol().getType() == 43;
    }

    private static boolean haveExprNotWithParens(SDBLParser.PredicateContext ctx) {
        BSLParserRuleContext rootCtx = Trees.getRootParent((BSLParserRuleContext)ctx, RULES_OF_PARENT_FOR_SEARCH_CONDITION);
        if (rootCtx == null || rootCtx.getRuleIndex() == 6) {
            return false;
        }
        return rootCtx.getChildCount() == 4 && FieldsFromJoinsWithoutIsNullDiagnostic.isTerminalNodeNOT(rootCtx.getChild(0));
    }

    private void checkSelect(String tableName, SDBLParser.SelectedFieldsContext columns) {
        this.checkStatements(tableName, (BSLParserRuleContext)columns, SELECT_STATEMENTS, EXCLUDED_TOP_RULE_FOR_SELECT, true);
    }

    private void checkStatements(String tableName, BSLParserRuleContext expression, Collection<Integer> statements, Integer rootForStatement, boolean checkIsNullOperator) {
        Trees.findAllRuleNodes((ParseTree)expression, 25).stream().filter(Objects::nonNull).filter(SDBLParser.ColumnContext.class::isInstance).map(SDBLParser.ColumnContext.class::cast).filter(columnContext -> FieldsFromJoinsWithoutIsNullDiagnostic.checkColumn(tableName, columnContext, statements, rootForStatement, checkIsNullOperator)).collect(Collectors.toCollection(() -> this.nodesForIssues));
    }

    private static boolean checkColumn(String tableName, SDBLParser.ColumnContext columnCtx, Collection<Integer> statements, Integer rootForStatement, boolean checkIsNullOperator) {
        return Optional.of(columnCtx).filter(columnContext -> columnContext.mdoName != null).filter(columnContext -> columnContext.mdoName.getText().equalsIgnoreCase(tableName)).filter(columnContext -> !FieldsFromJoinsWithoutIsNullDiagnostic.haveIsNullInsideExprForColumn((BSLParserRuleContext)columnContext, statements, rootForStatement, checkIsNullOperator)).isPresent();
    }

    private static boolean haveIsNullInsideExprForColumn(BSLParserRuleContext ctx, Collection<Integer> statements, Integer rootForStatement, boolean checkIsNullOperator) {
        BSLParserRuleContext selectStatement = Trees.getRootParent(ctx, statements);
        if (selectStatement == null || selectStatement.getChildCount() == 0 || rootForStatement.intValue() == selectStatement.getRuleIndex()) {
            return false;
        }
        if (checkIsNullOperator && FieldsFromJoinsWithoutIsNullDiagnostic.haveIsNullOperator(selectStatement)) {
            return true;
        }
        return FieldsFromJoinsWithoutIsNullDiagnostic.haveIsNullFunction(selectStatement) || FieldsFromJoinsWithoutIsNullDiagnostic.haveIsNullInsideExprForColumn(selectStatement, statements, rootForStatement, checkIsNullOperator);
    }

    private static boolean haveIsNullOperator(BSLParserRuleContext ctx) {
        return Optional.of(ctx).filter(SDBLParser.IsNullPredicateContext.class::isInstance).map(SDBLParser.IsNullPredicateContext.class::cast).isPresent();
    }

    private static boolean haveIsNullFunction(BSLParserRuleContext ctx) {
        return Optional.of(ctx).filter(SDBLParser.BuiltInFunctionsContext.class::isInstance).map(SDBLParser.BuiltInFunctionsContext.class::cast).map(SDBLParser.BuiltInFunctionsContext::ISNULL).isPresent();
    }

    private void checkWhere(String tableName, @Nullable SDBLParser.LogicalExpressionContext where) {
        Optional.ofNullable(where).stream().flatMap(searchConditionsContext -> searchConditionsContext.condidions.stream()).forEach(searchConditionContext -> this.checkStatements(tableName, (BSLParserRuleContext)searchConditionContext, WHERE_STATEMENTS, EXCLUDED_TOP_RULE_FOR_WHERE, true));
    }

    private void checkAllJoins(String tableName, SDBLParser.JoinPartContext currentJoinPart) {
        Optional.ofNullable(Trees.getRootParent((BSLParserRuleContext)currentJoinPart, 47)).filter(SDBLParser.DataSourceContext.class::isInstance).stream().flatMap(ctx -> ((SDBLParser.DataSourceContext)ctx).joinPart().stream()).filter(joinPartContext -> joinPartContext != currentJoinPart).map(SDBLParser.JoinPartContext::logicalExpression).forEach(searchConditionsContext -> this.checkStatements(tableName, (BSLParserRuleContext)searchConditionsContext, JOIN_STATEMENTS, EXCLUDED_TOP_RULE_FOR_JOIN, false));
    }

    private List<DiagnosticRelatedInformation> getRelatedInformation(SDBLParser.JoinPartContext self) {
        return this.nodesForIssues.stream().filter(ctx -> !ctx.equals(self)).map(context -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)context), "+1")).collect(Collectors.toList());
    }
}

