/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectComplex;
import com.github._1c_syntax.mdclasses.mdo.attributes.TabularSection;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.regex.Pattern;
import lombok.Generated;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.SQL, DiagnosticTag.DESIGN}, modules={ModuleType.ManagerModule, ModuleType.ObjectModule, ModuleType.ValueManagerModule, ModuleType.SessionModule}, scope=DiagnosticScope.BSL)
public class ForbiddenMetadataNameDiagnostic
extends AbstractMetadataDiagnostic {
    private static final String FORBIDDEN_NAMES = "AccountingRegister|AccountingRegisters|AccumulationRegister|AccumulationRegisters|BusinessProcess|BusinessProcesses|CalculationRegister|CalculationRegisters|Catalog|Catalogs|ChartOfAccounts|ChartOfCalculationTypes|ChartOfCharacteristicTypes|ChartsOfAccounts|ChartsOfCalculationTypes|ChartsOfCharacteristicTypes|Constant|Constants|Document|DocumentJournal|DocumentJournals|Documents|Enum|Enums|ExchangePlan|ExchangePlans|FilterCriteria|FilterCriterion|InformationRegister|InformationRegisters|Task|Tasks|\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441|\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u044b|\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442|\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b|\u0416\u0443\u0440\u043d\u0430\u043b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432|\u0416\u0443\u0440\u043d\u0430\u043b\u044b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432|\u0417\u0430\u0434\u0430\u0447\u0430|\u0417\u0430\u0434\u0430\u0447\u0438|\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430|\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b|\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0438\u041e\u0442\u0431\u043e\u0440\u0430|\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439\u041e\u0442\u0431\u043e\u0440\u0430|\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435|\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f|\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a|\u041f\u043b\u0430\u043d\u041e\u0431\u043c\u0435\u043d\u0430|\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432|\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a|\u041f\u043b\u0430\u043d\u044b\u041e\u0431\u043c\u0435\u043d\u0430|\u041f\u043b\u0430\u043d\u044b\u0421\u0447\u0435\u0442\u043e\u0432|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439|\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a|\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438";
    private static final Pattern FORBIDDEN_NAMES_PATTERN = CaseInsensitivePattern.compile((String)"AccountingRegister|AccountingRegisters|AccumulationRegister|AccumulationRegisters|BusinessProcess|BusinessProcesses|CalculationRegister|CalculationRegisters|Catalog|Catalogs|ChartOfAccounts|ChartOfCalculationTypes|ChartOfCharacteristicTypes|ChartsOfAccounts|ChartsOfCalculationTypes|ChartsOfCharacteristicTypes|Constant|Constants|Document|DocumentJournal|DocumentJournals|Documents|Enum|Enums|ExchangePlan|ExchangePlans|FilterCriteria|FilterCriterion|InformationRegister|InformationRegisters|Task|Tasks|\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441|\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u044b|\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442|\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b|\u0416\u0443\u0440\u043d\u0430\u043b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432|\u0416\u0443\u0440\u043d\u0430\u043b\u044b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432|\u0417\u0430\u0434\u0430\u0447\u0430|\u0417\u0430\u0434\u0430\u0447\u0438|\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430|\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b|\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0438\u041e\u0442\u0431\u043e\u0440\u0430|\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439\u041e\u0442\u0431\u043e\u0440\u0430|\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435|\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f|\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a|\u041f\u043b\u0430\u043d\u041e\u0431\u043c\u0435\u043d\u0430|\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432|\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a|\u041f\u043b\u0430\u043d\u044b\u041e\u0431\u043c\u0435\u043d\u0430|\u041f\u043b\u0430\u043d\u044b\u0421\u0447\u0435\u0442\u043e\u0432|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0420\u0430\u0441\u0447\u0435\u0442\u0430|\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439|\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a|\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438");
    private final LanguageServerConfiguration serverConfiguration;

    @Override
    protected void checkMetadata(AbstractMDObjectBase mdo) {
        this.checkName(mdo.getName(), mdo.getMdoReference());
        if (mdo instanceof AbstractMDObjectComplex) {
            ((AbstractMDObjectComplex)mdo).getAttributes().forEach(attribute -> this.checkName(attribute.getName(), attribute.getMdoReference()));
            ((AbstractMDObjectComplex)mdo).getAttributes().stream().filter(TabularSection.class::isInstance).map(TabularSection.class::cast).map(TabularSection::getAttributes).flatMap(Collection::stream).forEach(attribute -> this.checkName(attribute.getName(), attribute.getMdoReference()));
        }
    }

    private void checkName(String name, MdoReference mdoReference) {
        if (FORBIDDEN_NAMES_PATTERN.matcher(name).matches()) {
            String mdoRef = this.serverConfiguration.getLanguage() == Language.RU ? mdoReference.getMdoRefRu() : mdoReference.getMdoRef();
            this.addDiagnostic(this.info.getMessage(name, mdoRef));
        }
    }

    @ConstructorProperties(value={"serverConfiguration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ForbiddenMetadataNameDiagnostic(LanguageServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }
}

