/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.model.Location;
import com.github._1c_syntax.bsl.languageserver.references.model.LocationRepository;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Symbol;
import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrence;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.ERROR})
public class MissingCommonModuleMethodDiagnostic
extends AbstractDiagnostic {
    public static final String PRIVATE_METHOD_MESSAGE = "privateMethod";
    private final LocationRepository locationRepository;

    private static String getMethodNameByLocation(BSLParserRuleContext node, Range range) {
        return Trees.findTerminalNodeContainsPosition(node, range.getEnd()).map(ParseTree::getText).orElseThrow();
    }

    @Override
    protected void check() {
        if (this.documentContext.getServerContext().getConfiguration().getConfigurationSource() == ConfigurationSource.EMPTY) {
            return;
        }
        this.locationRepository.getSymbolOccurrencesByLocationUri(this.documentContext.getUri()).filter(symbolOccurrence -> symbolOccurrence.getOccurrenceType() == OccurrenceType.REFERENCE).filter(symbolOccurrence -> symbolOccurrence.getSymbol().getSymbolKind() == SymbolKind.Method).filter(symbolOccurrence -> symbolOccurrence.getSymbol().getModuleType() == ModuleType.CommonModule).map(this::getReferenceToMethodCall).flatMap(Optional::stream).forEach(this::fireIssue);
    }

    private Optional<CallData> getReferenceToMethodCall(SymbolOccurrence symbolOccurrence) {
        Symbol symbol = symbolOccurrence.getSymbol();
        Optional<DocumentContext> document = this.documentContext.getServerContext().getDocument(symbol.getMdoRef(), symbol.getModuleType());
        if (document.isEmpty()) {
            return Optional.empty();
        }
        Optional<AbstractMDObjectBase> mdObject = document.get().getMdObject();
        if (mdObject.isEmpty()) {
            return Optional.empty();
        }
        Optional<MethodSymbol> methodSymbol = document.get().getSymbolTree().getMethodSymbol(symbol.getSymbolName());
        if (methodSymbol.isEmpty()) {
            Location location = symbolOccurrence.getLocation();
            return Optional.of(new CallData(mdObject.get().getName(), MissingCommonModuleMethodDiagnostic.getMethodNameByLocation((BSLParserRuleContext)this.documentContext.getAst(), location.getRange()), location.getRange(), false, false));
        }
        if (document.get().getUri().equals(this.documentContext.getUri())) {
            return Optional.empty();
        }
        return methodSymbol.filter(methodSymbol2 -> !methodSymbol2.isExport()).map(methodSymbol1 -> new CallData(((AbstractMDObjectBase)mdObject.get()).getName(), methodSymbol1.getName(), symbolOccurrence.getLocation().getRange(), true, true));
    }

    private void fireIssue(CallData callData) {
        String message = !callData.exists ? this.info.getMessage(callData.methodName, callData.moduleName) : this.info.getResourceString(PRIVATE_METHOD_MESSAGE, callData.methodName, callData.moduleName);
        this.diagnosticStorage.addDiagnostic(callData.moduleMethodRange, message);
    }

    @ConstructorProperties(value={"locationRepository"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MissingCommonModuleMethodDiagnostic(LocationRepository locationRepository) {
        this.locationRepository = locationRepository;
    }

    private static final class CallData {
        private final String moduleName;
        private final String methodName;
        private final Range moduleMethodRange;
        private final boolean nonExport;
        private final boolean exists;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getModuleName() {
            return this.moduleName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Range getModuleMethodRange() {
            return this.moduleMethodRange;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isNonExport() {
            return this.nonExport;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isExists() {
            return this.exists;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallData)) {
                return false;
            }
            CallData other = (CallData)o;
            if (this.isNonExport() != other.isNonExport()) {
                return false;
            }
            if (this.isExists() != other.isExists()) {
                return false;
            }
            String this$moduleName = this.getModuleName();
            String other$moduleName = other.getModuleName();
            if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            Range this$moduleMethodRange = this.getModuleMethodRange();
            Range other$moduleMethodRange = other.getModuleMethodRange();
            return !(this$moduleMethodRange == null ? other$moduleMethodRange != null : !this$moduleMethodRange.equals(other$moduleMethodRange));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNonExport() ? 79 : 97);
            result = result * 59 + (this.isExists() ? 79 : 97);
            String $moduleName = this.getModuleName();
            result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            Range $moduleMethodRange = this.getModuleMethodRange();
            result = result * 59 + ($moduleMethodRange == null ? 43 : $moduleMethodRange.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "MissingCommonModuleMethodDiagnostic.CallData(moduleName=" + this.getModuleName() + ", methodName=" + this.getMethodName() + ", moduleMethodRange=" + this.getModuleMethodRange() + ", nonExport=" + this.isNonExport() + ", exists=" + this.isExists() + ")";
        }

        @ConstructorProperties(value={"moduleName", "methodName", "moduleMethodRange", "nonExport", "exists"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CallData(String moduleName, String methodName, Range moduleMethodRange, boolean nonExport, boolean exists) {
            this.moduleName = moduleName;
            this.methodName = methodName;
            this.moduleMethodRange = moduleMethodRange;
            this.nonExport = nonExport;
            this.exists = exists;
        }
    }
}

