/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.STANDARD})
public class MissingTemporaryFileDeletionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String REGEX_DELETION_FILE = "\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u0424\u0430\u0439\u043b\u044b|DeleteFiles|\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432|BeginDeletingFiles|\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c\u0424\u0430\u0439\u043b|MoveFile";
    private static final Pattern GET_TEMP_FILE_NAME_PATTERN = CaseInsensitivePattern.compile((String)"^(\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0418\u043c\u044f\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e\u0424\u0430\u0439\u043b\u0430|GetTempFileName)");
    @DiagnosticParameter(type=String.class, defaultValue="\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u0424\u0430\u0439\u043b\u044b|DeleteFiles|\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432|BeginDeletingFiles|\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c\u0424\u0430\u0439\u043b|MoveFile")
    private Pattern searchDeleteFileMethod = CaseInsensitivePattern.compile((String)"^(\u0423\u0434\u0430\u043b\u0438\u0442\u044c\u0424\u0430\u0439\u043b\u044b|DeleteFiles|\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u043e\u0432|BeginDeletingFiles|\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c\u0424\u0430\u0439\u043b|MoveFile)");

    @Override
    public void configure(Map<String, Object> configuration) {
        String searchDeleteFileMethodProperty = (String)configuration.getOrDefault("searchDeleteFileMethod", REGEX_DELETION_FILE);
        this.searchDeleteFileMethod = CaseInsensitivePattern.compile((String)("^(" + searchDeleteFileMethodProperty.replace(".", "\\.") + ")"));
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.MethodNameContext methodNameContext = ctx.methodName();
        if (methodNameContext == null) {
            return (ParseTree)super.visitGlobalMethodCall(ctx);
        }
        Matcher matcher = GET_TEMP_FILE_NAME_PATTERN.matcher(methodNameContext.getText());
        if (matcher.find()) {
            String variableName = MissingTemporaryFileDeletionDiagnostic.getVariableName(ctx);
            if (variableName == null) {
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
                return (ParseTree)super.visitGlobalMethodCall(ctx);
            }
            int filterLine = ctx.getStart().getLine();
            BSLParser.CodeBlockContext codeBlockContext = (BSLParser.CodeBlockContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, 72);
            if (codeBlockContext != null && !this.foundDeleteFile(codeBlockContext, variableName, filterLine)) {
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
            }
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    private boolean foundDeleteFile(BSLParser.CodeBlockContext codeBlockContext, String variableName, int filterLine) {
        boolean result = false;
        List listCallStatements = Trees.findAllRuleNodes((ParseTree)codeBlockContext, 93, 99).stream().map(BSLParserRuleContext.class::cast).filter(node -> node.getStart().getLine() > filterLine).collect(Collectors.toList());
        for (BSLParserRuleContext node2 : listCallStatements) {
            Matcher matcher;
            BSLParser.DoCallContext doCallContext;
            String fullCallMethod;
            if (node2 instanceof BSLParser.GlobalMethodCallContext) {
                fullCallMethod = ((BSLParser.GlobalMethodCallContext)node2).methodName().getText();
                doCallContext = ((BSLParser.GlobalMethodCallContext)node2).doCall();
            } else {
                fullCallMethod = MissingTemporaryFileDeletionDiagnostic.getFullMethodName((BSLParser.AccessCallContext)node2);
                doCallContext = ((BSLParser.AccessCallContext)node2).methodCall().doCall();
            }
            if (doCallContext == null || !(matcher = this.searchDeleteFileMethod.matcher(fullCallMethod)).matches() || fullCallMethod.length() <= 0 || !MissingTemporaryFileDeletionDiagnostic.foundVariableInCallParams(doCallContext, variableName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean foundVariableInCallParams(BSLParser.DoCallContext doCallContext, String variableName) {
        BSLParser.CallParamListContext callParamListContext = doCallContext.callParamList();
        if (callParamListContext == null) {
            return false;
        }
        List list = callParamListContext.callParam();
        if (list.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (BSLParser.CallParamContext callParamContext : list) {
            if (!callParamContext.getText().equalsIgnoreCase(variableName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static String getVariableName(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.AssignmentContext assignment = (BSLParser.AssignmentContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, 81);
        if (assignment == null) {
            return null;
        }
        BSLParser.LValueContext lValue = assignment.lValue();
        if (lValue == null) {
            return null;
        }
        return lValue.getText();
    }

    private static String getFullMethodName(BSLParser.AccessCallContext ctx) {
        List modifiers;
        BSLParserRuleContext parent = ctx.getParent();
        String prefix = "";
        if (parent instanceof BSLParser.CallStatementContext) {
            BSLParser.CallStatementContext callStatement = (BSLParser.CallStatementContext)parent;
            modifiers = callStatement.modifier();
            prefix = callStatement.globalMethodCall() != null ? callStatement.globalMethodCall().methodName().IDENTIFIER().getText() : callStatement.IDENTIFIER().getText();
        } else if (parent instanceof BSLParser.ModifierContext && parent.getParent() instanceof BSLParser.ComplexIdentifierContext) {
            BSLParser.ComplexIdentifierContext root = (BSLParser.ComplexIdentifierContext)parent.getParent();
            modifiers = root.modifier();
            TerminalNode terminalNode = root.IDENTIFIER();
            if (terminalNode != null) {
                prefix = terminalNode.getText();
            }
        } else {
            return "";
        }
        return prefix + modifiers.stream().takeWhile(element -> element != parent).map(ParseTree::getText).collect(Collectors.joining()) + "." + ctx.methodCall().methodName().IDENTIFIER().getText();
    }
}

