/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD})
public class NumberOfOptionalParamsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_OPTIONAL_PARAMS_COUNT = 3;
    @DiagnosticParameter(type=Integer.class, defaultValue="3")
    private int maxOptionalParamsCount = 3;

    public ParseTree visitParamList(BSLParser.ParamListContext ctx) {
        int paramCount = (int)ctx.param().stream().filter(param -> param.defaultValue() != null).count();
        if (paramCount > this.maxOptionalParamsCount) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(paramCount, this.maxOptionalParamsCount));
        }
        return ctx;
    }
}

